unit SpectrScopes03;
// ====================================================================
(*
                  

       1.  TSpectrScope (    )
       2.  TPhaseScope  (   )
       3.  TSignalScope (    )

       , 
   ,        
    .

            (TPanel).
           
      .
             
    ,     EXCEL
   // -----------------------------------------------------
    3.5. ()  , , , 2017..2020 .
               () Source code  ..
     27.12.2019
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils,Variants, Classes, Graphics, Controls, Dialogs,
  StrUtils,  ExtCtrls, ExtDlgs, Menus, ComObj, Jpeg,  Math;

// ====================================================================
//      
// ====================================================================
// --------------------------------------------------------------------
//        
// --------------------------------------------------------------------
//         
const Scope_Ver = ' Ver.3.01.';        //   
const Spectr_ID = ' Ver 1.01.';  //    
const Signal_ID = ' Ver 1.01.';  //    
const Comment_ID  = '//';              //   
const Comment_Dlm = ' ';               //    
const XB_ID = 'XB';                    //   XB
const XE_ID = 'XE';                    //   XE
const Data_Dlm = char($09);            //    
const MinXRange = 1e-10;               //    X
// --------------------------------------------------------------------
//  
// --------------------------------------------------------------------
//       
type TGarmonic = record
   Amp      : double;  //   
   Phs      : double;  //     
end;
// --------------------------------------------------------------------
//     
type TArrSpectr = array of TGarmonic;
// --------------------------------------------------------------------
//   Y -  
type TArrSignal = array of double;
// --------------------------------------------------------------------
// ====================================================================
//  TSpectrScope ( )
// ====================================================================
// --------------------------------------------------------------------
//    
const MinSpectrPanelWidth  = 630;   //    
      MinSpectrPanelHeight = 250;   //    
// --------------------------------------------------------------------
//   
const SpectrMaxYMark = 10;          //     Y
// --------------------------------------------------------------------
//   "  "
type TOnGrmSelect = procedure(Sender : TObject;
                              Num : integer; ArrSpectr : TArrSpectr) of object;
// --------------------------------------------------------------------
//   "   "
type TOnSpectrLoad  = procedure(Sender : TObject;
                                ArrSpectr : TArrSpectr) of object;
 // --------------------------------------------------------------------
//   "   TSpectrScope.Free"
type TOnSpecrtDestroy  = procedure(Sender : TObject) of object;
// --------------------------------------------------------------------
//   "   TSignalScope.Free"
type TOnSignalDestroy  = procedure(Sender : TObject) of object;
// --------------------------------------------------------------------
//   "     "
type TOnSignalReady  = procedure(Sender    : TObject;
                                 ArrSignal : TArrSignal) of object;
// --------------------------------------------------------------------
//  ()  
type TSpectrScopeMode = (smAmpMode, smPhaseMode);
// --------------------------------------------------------------------

type TSpectrScope = class(TObject)
private
    fPanel    : TPanel;           //  
    fTimer    : TTimer;           //     ReSize
    // --------------------
    fImg      : TImage;           // Image  
    fImgRect  : TRect;            //   
    fBMP      : TBitMap;          //  
    fPUMenu   : TPopupMenu;       // PopUpMenu
    // --------------------
    fArrSpectr   : TArrSpectr;    //    
    fMode     : TSpectrScopeMode; //   AMP/PHS
    fAmpMax   : double;           //     
    // --------------------
    fBgColor  : TColor;           //  
    fAmpColor : TColor;           //   
    fPhsColor : TColor;           //   
    fBWMode   : boolean;          // -  
    // --------------------
    fAreaFnc   : TRect;           //    /
    fAreaAxY   : TRect;           //    Y
    fAreaAxX   : TRect;           //      X
    fAreaMsg   : TRect;           //     
    fAreaMod   : TRect;           //    
    // --------------------
    fXB        : double;          //  X - 
    fXE        : double;          //   X - 
    // --------------------
    fScaleY   : double;           //   Y
    fScaleX   : double;           //   X
    // --------------------
    fSelectNum            : integer;     //     -1
    fSelectNumColor  : TColor;           //   
    // --------------------
    fOnSpectrLoad    : TOnSpectrLoad;    // "   "
    fOnGrmSelect     : TOnGrmSelect;     // "  "

    fOnSpecrtDestroy : TOnSpecrtDestroy; // "   Free"
    // --------------------
    fLoadArrSpectr      : TArrSpectr;    //   LoadFromFile
    // --------------------
    //   Resize  
    procedure onPanelResize(Sender: TObject);
    //     ReSize
    procedure onReSizeTimer(Sender: TObject);
    //   SpectrScope     
    procedure ReSize();
    // --------------------
    //     fImg
    procedure BmpToImg ();
    // --------------------
    //   
    procedure BmpColorScheme(FontColor, PenColor, BrushColor : TColor);
    //   
    procedure BmpClear();
    //    
    procedure BmpAreaClear (RqArea : TRect; RqColor : TColor);
    //    PopupMenu
    procedure GreateAndConnecPoUpMenu();
    // --------------------
    //    
    procedure BmpShowMode();
    //  
    procedure BmpShowMsg (RqX : integer; RqColor : TColor; RqMsg : string);
    //   
    procedure BmpShowErrorMsg (RqMsg : string);
    // --------------------
    //     
    function GrmTxtDesc(RqNum : integer) : string;
    //   MouseDown  fImg
    procedure MouseDown(Sender: TObject; Button: TMouseButton;
                        Shift: TShiftState; X, Y: Integer);
    //    PopupMenu
    procedure MenuClick(Sender : TObject);
    // --------------------
    //     
    procedure CalcAreas();
    // --------------------
    //     
    procedure CalcMaxY();
    //    Y    
    procedure CalcScaleY();
    //         Y
    function CalcFormatStringY(): string;
    //       Y
    procedure BmpSubscriptAxesY();
    //     Y
    procedure BmpShowAxesY();
    // --------------------
    //    X    
    procedure CalcScaleX();
    //       X
    procedure BmpSubscriptAxesX();
    //     X
    procedure BmpShowAxesX();
    // --------------------
    //      
    procedure BmpShowSpectrLine();
    // --------------------
    //      
    function GetSubStr(RqDelimiter : string; var RqStr : string) : string;
    //  " "   XB XE  LoadFromSpectrFile
    function DetectCommentAndXBXE(RqStr : string) : boolean;
    // --------------------
    //      Excel
    procedure WriteToExcelSheet(XLApp : Variant);
    //      Excel
    procedure MarkupExcelSheet(XLApp : Variant);
    //    Excel
    procedure ExportToExcel();
    // --------------------
    //   
    function DialogColor(RqDefColor : TColor) : TColor;
    // --------------------
    //  property ArrSpectr
    procedure SetArrSpectr(RqArrSpectr : TArrSpectr);
    //  property fSelectNum
    procedure SetSNum(RqSNum : integer);
    //  property ArrItem
    function  GetSelectArrItem() : TGarmonic;
    procedure SetSelectArrItem(RqItem : TGarmonic);
    // --------------------
    //    
    procedure SetXB(RqXB : double);
    //    
    procedure SetXE(RqXE : double);
public
    // --------------------
    constructor Create(RqPanel : TPanel);
    procedure Free();
    // --------------------
    //         X  Y
    procedure Show();
    ///         X  Y
    procedure ReShow();
    //   
    procedure ClearShow();
    //   
    procedure SaveToFile(RqFileName : string; RqDelimitor : char);
    //       
    function DialogSaveToFile() : string;
    //   
    procedure LoadFromFile(RqFileName  : string; RqDelimitor : char);
    //       
    //     (char($09))
    function DialogLoadFromFile() : string;
    //  /     
    procedure DialogLoadSpectrOnOff(RqOn : boolean);
    // --------------------
    //    
    property ArrSpectr : TArrSpectr read fArrSpectr write SetArrSpectr;
    //   
    property AmpColor : TColor read fAmpColor write fAmpColor;
    //   
    property PhsColor : TColor read fPhsColor write fPhsColor;
    //   
    property SelectNum : integer read fSelectNum write SetSNum;
    //   
    property SelectNumColor : TColor read fSelectNumColor write fSelectNumColor;
    //     
    property SelectGrm : TGarmonic read GetSelectArrItem
                                   write SetSelectArrItem;
    // --------------------
    //      
    property XB : double read fXB write SetXB;
    //      
    property XE : double read fXE write SetXE;
    // --------------------
    //   "  "
    property OnGrmSelect : TOnGrmSelect read fOnGrmSelect
                                       write fOnGrmSelect;
    //   "   Free"
    property OnSpecrtDestroy : TOnSpecrtDestroy read  fOnSpecrtDestroy
                                                write fOnSpecrtDestroy;
    //    "   "
    property OnSpectrLoad : TOnSpectrLoad read  fOnSpectrLoad
                                          write fOnSpectrLoad;
    //   Image SectrScope
    property SectrImg : TImage read fImg;
end;

// ====================================================================
//  TPhaseScope ( )
// ====================================================================
//     
const MinPhasePanelLen  = 200;
// --------------------------------------------------------------------
type TPhaseScope = class(TObject)
private
    fPanel    : TPanel;        //  
    // --------------------
    fImg      : TImage;        // Image  
    fImgRect  : TRect;         //   
    fBMP      : TBitMap;       //  
    fPUMenu   : TPopupMenu;    // PopUpMenu
    // --------------------
    fArrSpectr   : TArrSpectr; //    
    // --------------------
    fAreaMsgU : TRect;         //      
    fAreaAxs  : TRect;         //    
    fAreaPHS  : TRect;         //    
    fAreaMsgD : TRect;         //      
    // --------------------
    fBgColor  : TColor;        //  
    fPhsColor : TColor;        //   
    fBWMode   : boolean;       // -  
    fZeroX    : integer;       // X -    
    fZeroY    : integer;       // Y -    
    fVLen     : integer;       //    
    // --------------------
    fSelectNum     : integer;       //    
    // --------------------
    //     
    procedure CalcAreas();
    //     
    procedure BmpShowAxes ();
    //   
    procedure BmpClear();
    //        
    procedure BmpShowMsg (RqArea  : char; RqX : integer;
                          RqColor : TColor; RqMsg : string);
    //   
    procedure BmpShowErrorMsg (RqMsg : string);
    //    
    procedure BmpShowGrmValue();
    //     fImg
    procedure BmpToImg();
    //   
    function DialogColor(RqDefColor : TColor) : TColor;
    // --------------------
    //  property ArrSpectr
    procedure SetArrSpectr(RqArrSpectr : TArrSpectr);
    //  property SelectGNum
    procedure SetGNum(RqGNum : integer);
    // --------------------
    //    PopupMenu
    procedure GreateAndConnecPoUpMenu();
    //    
    procedure MenuClick(Sender : TObject);
public
    // --------------------
    constructor Create(RqPanel : TPanel);
    procedure Free();
    // --------------------
    //     fImg
    procedure Show ();
    // --------------------
    //    
    property ArrSpectr : TArrSpectr read fArrSpectr write SetArrSpectr;
    //  
    property BgColor : TColor read fBgColor write fBgColor;
    //   
    property PhsColor : TColor read fPhsColor write fPhsColor;
    //     
    property SelectNum : integer read fSelectNum write SetGNum;
    //   Image PhaseScope
    property PhaseImg : TImage read fImg;
end;

// ====================================================================
//  TSignalScope ( )
// ====================================================================
//    
const MinSignalPanelWidth  = 460;   //    
      MinSignalPanelHeight = 250;   //    
// --------------------------------------------------------------------
type TSignalScope = class(TObject)
private
    fPanel     : TPanel;         //  
    fTimer     : TTimer;         //     ReSize
    // --------------------
    fImg       : TImage;         // Image  
    fImgRect   : TRect;          //   
    fBMP       : TBitMap;        //  
    fPUMenu    : TPopupMenu;     // PopUpMenu
    // --------------------
    fArrSpectr     : TArrSpectr; //    
    fArrIndx    : integer;       //    fArrSpectr
    // --------------------
    fLoadArrSpectr : TArrSpectr; //    
    // --------------------
    fBgColor   : TColor;         //  
    fSignalColor : TColor;       //   
    fBWMode    : boolean;        // -  
    // --------------------
    fAreaFnc   : TRect;          //    
    fAreaAxY   : TRect;          //    Y
    fAreaAxX   : TRect;          //      X
    fAreaMsg   : TRect;          //     
    fAreaMod   : TRect;          //    
    // --------------------
    fNumPnt    : integer;        //    
    fArrSignal : TArrSignal;     //   
    // --------------------
    fPntStepX  : double;         // Pix -      X
    // --------------------
    fMaxAbsS   : double;         //   
    fZeroY     : integer;        // Pix-  Y  fAreaFnc.Top
    fYToPixY   : double;         //   Y     Y
    // --------------------
    fMouseX    : integer;        // Pix -    fImg
    fRulerStop : boolean;        //   
    // --------------------
    fXB        : double;         //   X - 
    fXE        : double;         //    X - 
    fScaleX    : double;         // Pix -   X   
    // --------------------
    // "   "
    fOnSpectrLoad    : TOnSpectrLoad;
    // "     "
    fOnSignalReady   : TOnSignalReady;
    // "   Free"
    fOnSignalDestroy : TOnSignalDestroy;
    // --------------------
    //   Resize  
    procedure onPanelResize(Sender: TObject);
    //     ReSize
    procedure onReSizeTimer(Sender: TObject);
    //   SignalScope     
    procedure ReSize();
    // --------------------
    //     
    procedure CalcAreas();
    // --------------------
    //   
    procedure BmpColorScheme(FontColor, PenColor, BrushColor : TColor);
    //   
    procedure BmpClear();
    //    
    procedure BmpAreaClear (RqArea : TRect; RqColor : TColor);
    //     
    procedure BmpShowMsg (RqX : integer; RqColor : TColor; RqMsg : string);
    //   
    procedure BmpShowErrorMsg (RqMsg : string);
    // --------------------
    //     fImg
    procedure BmpToImg();
    //      
    procedure BmpShow ();
    // --------------------
    //         Y
    function CalcFormatStringY(): string;
    //       Y
    procedure BmpSubscriptAxesY();
    //     Y
    procedure BmpShowAxesY();
    // --------------------
    //     X
    procedure BmpShowAxesX();
    //   
    procedure BmpShowSig();
    // --------------------
    //  .  Y     Y
    procedure CalcYToPixY();
    //   
    procedure CreateSignal();
    // --------------------
    //   
    function DialogColor(RqDefColor : TColor) : TColor;
    // --------------------
    //  " "   XB XE  LoadFromSpectrFile
    function DetectCommentAndXBXE(RqStr : string) : boolean;
    //      
    function GetSubStr(RqDelimiter : string; var RqStr : string) : string;
    // --------------------
    //      Excel
    procedure WriteToExcelSheet(XLApp : Variant);
    //      Excel
    procedure MarkupExcelSheet(XLApp : Variant);
    //    Excel
    procedure ExportToExcel();
    // --------------------
    //  property ArrSpectr
    procedure SetArrSpectr(RqArrSpectr : TArrSpectr);
    //       
    procedure SetArrNumPnt(RqNumPnt : integer);
    //    
    procedure SetXB(RqXB : double);
    //    
    procedure SetXE(RqXE : double);
    // --------------------
    //       
    procedure BmpSPointInfo(RqArrIndx : integer);
    //  X - mouse   
    procedure MouseXToArrIndx(RqX : integer);
    //  
    procedure BmpShowRuler(Shift: TShiftState; X, Y: Integer);
    //  
    procedure ReStartRuler();
    //     ( fImg.onMouseMove)
    procedure MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    // --------------------
    //    PopupMenu
    procedure GreateAndConnecPopUpMenu();
    //    
    procedure MenuClick(Sender : TObject);
public
    // --------------------
    constructor Create(RqPanel : TPanel);
    procedure Free();
    // --------------------
    //        
    procedure ReShow ();
    //        
    procedure Show ();
    // --------------------
    //    
    procedure LoadFromSpectrFile(RqFileName : string; RqDelimitor : char);
    //       
    //     (char($09))
    function DialogLoadFromSpecrtFile() : string;
    //  /   PopUpMemu   DialogLoadFromFile()
    procedure DialogLoadSpectrOnOff(RqOn : boolean);
    // --------------------
    //   
    procedure SaveToFile(RqFileName : string; RqDelimitor : char);
    //       
    function DialogSaveToFile() : string;
    // --------------------
    //        
    property ArrSpectr : TArrSpectr read fArrSpectr write SetArrSpectr;
    //     
    property ArrSignal : TArrSignal read fArrSignal;
    //         
    property SignalNumPnt : integer read fNumPnt      write SetArrNumPnt;
    //   
    property  MaxAbsY   : double    read fMaxAbsS;
    // ------
    //      
    property XB : double read fXB write SetXB;
    //      
    property XE : double read fXE write SetXE;
    // ------
    //  
    property BgColor : TColor       read fBgColor     write fBgColor;
    //   
    property SignalColor : TColor   read fSignalColor write fSignalColor;
    // --------------------
    //    "   "
    property OnSpectrLoad : TOnSpectrLoad   read  fOnSpectrLoad
                                            write fOnSpectrLoad;
    //    "     "
    property OnSignalReady : TOnSignalReady read  fOnSignalReady
                                            write fOnSignalReady;
    //   "   Free"
    property OnSignalDestroy : TOnSignalDestroy read  fOnSignalDestroy
                                                write fOnSignalDestroy;
    //   Image SignalScope
    property SignalImg : TImage read fImg;
end;

// =========================================================================
// =========================================================================
implementation
// =========================================================================
// =========================================================================
const TimeReSizeOut = 400;  //     ReSize

//   Img   
const ImgBordX = 2;
      ImgBordY = 2;

// =========================================================================
//  
// =========================================================================
// ------------------------------------------------------------------
//   Menu (MainMenu, PopUpMenu)    RqName
function FindMenuItem(RqMenu : TMenu;
                      RqName : string) : TMenuItem;
//    
function MSeek(Item : TMenuItem; RqName : string) : TMenuItem;
var Ind      : integer;
    SubItems : TMenuItem;
begin
    Result := nil;  Ind := 0;
    repeat
       // ShowMessage(Item[Ind].Name);  //  
       if Item[Ind].Name = RqName
       then begin
          Result := Item[Ind];  Exit;
        end;
        if Item[Ind].Count > 0
        then begin
           //  
           SubItems := Item[Ind];
           Result := MSeek(SubItems, RqName);
           if Result <> nil then Exit;
        end;
        Ind := Ind + 1;
    until (Ind > (Item.Count - 1));
end;   // of function MSeek
begin  // FindMenuItem
   Result := nil;
   if RqMenu.Items.Count < 1 then Exit;
   Result := MSeek(RqMenu.Items, RqName);
end;  // of function FindMenuItem
// --------------------------------------------------------------------
//  RqImg   RqFileName. (RqGF : 'J' - jpg   'B' -bmp)
function SavePicture(RqFileName : string;
                     RqImg      : TImage;
                     RqGF       : char) : boolean;
var  Jpeg   : TJPEGImage;  //   unit jpeg.
     BitMap : TBitMap;
begin
    Result  := False;      //   
    case UpCase(RqGF) of
    'J' : begin   //   Jpeg
            Jpeg := TJPEGImage.Create;
            try
              with Jpeg do
              begin                //  Bitmap  JPG
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
                 Result  := True;  //   
              end;
            finally
                 Jpeg.Free;        //   JPG
            end;
          end;
    'B': begin   //   BMP
            BitMap := TBitMap.Create;
            try
              with BitMap do        //  Bitmap  BMP
              begin
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
                 Result  := True;   //   
              end;
            finally
                 BitMap.Free;       //   BMP
            end;
         end;
       end; // of case
end;
// --------------------------------------------------------------------
//    
procedure DialogSavePicture (RqImg : TImage);
var   wDialog   : TSavePictureDialog;
      wFileName : string;
begin
  wDialog := TSavePictureDialog.Create(nil);
  try
    //    
    wDialog.Filter := 'Graphics files (*.jpg)|*.JPG';
    if wDialog.Execute
    then begin
      wFileName := wDialog.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> '.JPG'
      then wFileName := wFileName + '.jpg';
      //  
      if not FileExists(wFileName)
      then SavePicture(wFileName, RqImg, 'J')
      else if MessageDlg('   ! ' + #13#10
                       + '  : '
                       + ExtractFileName(wFileName),
                       mtWarning, [mbYes, mbNo], 0) = mrYes
           then SavePicture(wFileName, RqImg, 'J');
    end;
  finally
     wDialog.Free;
  end;
end;
// --------------------------------------------------------------------
//      TextOut
//  TCanvas,      
// (    TruType -  )
procedure CanvasSetAngle(RqCanvas : TCanvas;  //  Canvas
                         RqAngle  : Single;   //   
                         RqSize   : integer;  //  
                         RqName   : String);  //  
var
  LF   : TLOGFONT;  //  font -  Windows
  Ind  : integer;
begin
  //    LF
  FillChar(LF, SizeOf(LF), #0);
  //   () 
  LF.lfHeight := RqSize;
  //    ( )
  // LF.lfItalic := 1;
  // LF.lfUnderline := 1;
  // LF.lfStrikeOut := 1;
  //      (   )
  LF.lfEscapement  := Trunc(RqAngle * 10);
  LF.lfOrientation := Trunc(RqAngle * 10);
  //  CHARSET
  LF.lfCharSet := DEFAULT_CHARSET;
  //    PChar  lfFaceName
  for Ind := 0 to Length(LF.lfFaceName) - 1
  do if Ind + 1 > Length(RqName)
     then Break
     else LF.lfFaceName[Ind] := RqName[Ind + 1];
  //      Windows
  // function CreateFontIndirect; external gdi32 name 'CreateFontIndirectA';
  RqCanvas.Font.Handle := CreateFontIndirect(lf);
end;
// --------------------------------------------------------------------
//      TextOut
//  TCanvas (    TruType - )
procedure CanvasReSetAngle(RqCanvas : TCanvas;  //  Canvas
                           RqAngle  : Single);  //   
var  LF : TLOGFONT;     {Font information}
begin
  //   RqCanvas.Font.Handle   LF
  GetObject(RqCanvas.Font.Handle, SizeOf(LF), Addr(LF));
  //      (   )
  LF.lfEscapement  := Trunc(RqAngle * 10);
  LF.lfOrientation := Trunc(RqAngle * 10);
  //      Windows
  // function CreateFontIndirect; external gdi32 name 'CreateFontIndirectA';
  RqCanvas.Font.Handle := CreateFontIndirect(LF);
end;


// ====================================================================
//  TSpectrScope (  )
// ====================================================================
// --------------------------------------------------------------------
//   TSpectrScope (/)
// --------------------------------------------------------------------
constructor TSpectrScope.Create(RqPanel : TPanel);
begin
   if not Assigned(RqPanel) then Exit;
   // -----------------------------
   inherited Create;
   //  
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight := MinSpectrPanelHeight;
   fPanel.Constraints.MinWidth  := MinSpectrPanelWidth;
   //    ReSize
   if fPanel.Align = alNone
   then  fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   // --------------------
    fOnGrmSelect     := nil;           // "  "
    fOnSpectrLoad    := nil;           // "   "
    fOnSpecrtDestroy := nil;           // "   Free"
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX, ImgBordY,
                  fPanel.Width -2*ImgBordX,
                  fPanel.Height-2*ImgBordY);
   fImgRect := Rect(0,0, fImg.Width, fImg.Height);
   // -----------------------------
   //    MouseDown  fImg
   fImg.OnMouseDown := MouseDown;
   // -----------------------------
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Width  := fImg.Width;
   fBMP.Height := fImg.Height;
   // -----------------------------
   //    PopupMenu
   GreateAndConnecPoUpMenu();
   // -----------------------------
   fSelectNum   := -1;                 //    
   fSelectNumColor := RGB(255,50,50);  //     
   // -----------------------------
   CalcAreas();                        //    fImg
   // -----------------------------
   fBgColor  := RGB(64,64,64);         //  
   fAmpColor := clLime;                //   
   fPhsColor := RGB(100,255,255);      //   
   BmpClear ();                        //   fImg
   // -----------------------------
   BmpShowMsg(4, clGray, ' / .'
                          + Scope_Ver);
   // -----------------------------
   fMode := smAmpMode;                 //    AMP
   BmpShowMode();                      //   
   // -----------------------------
   //     fImg
   BmpToImg ();
   // -----------------------------
   //    ReSize
   fTimer          := TTimer.Create(nil);
   fTimer.Enabled  := False;
   fTimer.OnTimer  := onReSizeTimer;
   fTimer.Interval := TimeReSizeOut;
   // -----------------------------
   fPanel.OnResize := OnPanelResize;
end;

// --------------------------------------------------------------------
procedure TSpectrScope.Free();
begin
    fPanel.OnResize := nil;
    if Assigned(fTimer) then fTimer.Free;
    //   "   Free"
    if Assigned(fOnSpecrtDestroy) then fOnSpecrtDestroy(Self);
    SetLength(fLoadArrSpectr, 0);
    if Assigned(fPUMenu) then fPUMenu.Free;
    if Assigned(fBMP) then fBMP.Free;
    fImg.Free;
    inherited Free;
end;
// --------------------------------------------------------------------
//  ReSize
// --------------------------------------------------------------------
//   Resize  
procedure TSpectrScope.onPanelResize(Sender: TObject);
begin
   if fImg.Visible
   then begin
       fImg.Visible := False;
       fTimer.Enabled := True;
   end;
   fTimer.Interval := TimeReSizeOut;
end;
// --------------------------------------------------------------------
//     ReSize
procedure TSpectrScope.onReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled := False;
   ReSize;
end;
// --------------------------------------------------------------------
//   SpectrScope     
procedure TSpectrScope.ReSize();
begin
   if fImg.Visible then fImg.Visible := False;
   with fImg do
   begin
      Picture.Bitmap.Width  := fPanel.Width  - 2 * ImgBordX;
      Picture.Bitmap.Height := fPanel.Height - 2 * ImgBordY;
      fBMP.Width  :=  Picture.Bitmap.Width;
      fBMP.Height :=  Picture.Bitmap.Height;
      Width  :=  Picture.Bitmap.Width;
      Height :=  Picture.Bitmap.Height;
   end;
   fImgRect := Rect(0,0, fImg.Width, fImg.Height);
   CalcAreas();
   Show;
   fImg.Visible := True;
end;
// --------------------------------------------------------------------
//  TSpectrScope (    )
// --------------------------------------------------------------------
//     fImg
procedure TSpectrScope.BmpToImg ();
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  fImg.Canvas.CopyRect(fImgRect,fBMP.Canvas,fImgRect);
end;
// --------------------------------------------------------------------
//     
procedure TSpectrScope.CalcAreas();
const
      AreasX  = 5;      //     X
      AreasY  = 8;      //     Y
      Mod_W   = 50;     //    fAreaMsg  fAreaAxY
      Mod_H   = 20;     //    fAreaMod
      Msg_H   = Mod_H;  //    fAreaMsg
      AxX_H   = 26;     //    fAreaAxX
begin
   //    
   fAreaMod := Rect(ImgBordX    + AreasX,
                    fImg.Height - ImgBordY - Mod_H,
                    ImgBordX    + Mod_W,
                    fImg.Height - ImgBordY);
   //     
   fAreaMsg := Rect(fAreaMod.Right + 1,
                    fImg.Height - ImgBordY - Msg_H,
                    fImg.Width  - AreasX - ImgBordX,
                    fImg.Height - ImgBordY);
   //    X
   fAreaAxX  := Rect(fAreaMod.Right + 1,
                    fAreaMsg.Top  - 1 - AxX_H,
                    fImg.Width    - AreasX - ImgBordX,
                    fAreaMsg.Top  - 1);
   //   
   fAreaFnc  := Rect(fAreaMod.Right + 1,
                    ImgBordY + AreasY,
                    fImg.Width    - AreasX - ImgBordX,
                    fAreaAxX.Top   - 1);
   //    Y
   fAreaAxY  := Rect(ImgBordX + AreasX,
                    ImgBordY + AreasY,
                    fAreaFnc.Left - 1,
                    fAreaFnc.Bottom);
end;
// --------------------------------------------------------------------
//   
procedure TSpectrScope.BmpColorScheme(FontColor, PenColor, BrushColor : TColor);
begin
  with fBMP.Canvas do
  begin
    if not fBWMode
    then begin
      Font.Color  := FontColor;
      Pen.Color   := PenColor;
      Brush.Color := BrushColor;
    end
    else begin
      //  -   
      Font.Color  := clBlack;
      Pen.Color   := clBlack;
      Brush.Color := clWhite;
    end;
  end;
end;
// --------------------------------------------------------------------
//   
procedure TSpectrScope.BmpClear();
begin
  with fBMP.Canvas do
  begin
    Brush.Style := bsSolid;
    BmpColorScheme(clWhite, clWhite, fBgColor);
    FillRect(Rect(0,0,fBMP.Width,fBMP.Height));
  end;
end;
// --------------------------------------------------------------------
//    
procedure TSpectrScope.BmpAreaClear (RqArea : TRect; RqColor : TColor);
begin
  with fBMP.Canvas do
  begin
    Brush.Style := bsSolid;
    BmpColorScheme(clWhite, clWhite, RqColor);
    FillRect(Rect(RqArea.Left, RqArea.Top, RqArea.Right + 1, RqArea.Bottom +1));
  end;
end;

// --------------------------------------------------------------------
//  TSpectrScope ( )
// --------------------------------------------------------------------
//   ()  
procedure TSpectrScope.BmpShowMode ();
var wFontSize  : integer;
begin
   BmpAreaClear(fAreaMod, fBgColor);
   with fBMP.Canvas
   do begin
     //   
     BmpColorScheme(clWhite, clWhite, fBgColor);
     wFontSize  := Font.Size;
     Font.Name  := 'Arial';
     Font.Size  := 10;
     case fMode of
        smAmpMode   : TextOut(fAreaMod.Left, fAreaMod.Top, 'AMP');
        smPhaseMode : TextOut(fAreaMod.Left, fAreaMod.Top, 'PHS');
     end;
     Font.Size  := wFontSize;
   end;
end;
// --------------------------------------------------------------------
//  
procedure TSpectrScope.BmpShowMsg (RqX : integer;  RqColor : TColor;
                                  RqMsg : string);
var wFontSize  : integer;
begin
   //   
   BmpAreaClear(fAreaMsg, fBgColor);
   with fBMP.Canvas
   do begin
     BmpColorScheme(RqColor, clWhite, fBgColor);
     wFontSize  := Font.Size;
     Font.Name := 'Arial';
     Font.Size := 9;
     TextOut(fAreaMsg.Left + RqX, fAreaMsg.Top + 1, RqMsg);
     Font.Size  := wFontSize;
   end;
end;
// --------------------------------------------------------------------
//   
procedure TSpectrScope.BmpShowErrorMsg (RqMsg : string);
begin
   BmpClear ();                     //   fImg
   BmpShowMsg(4, clRed, RqMsg);     //   
   BmpToImg ();                     //     fImg
end;
// --------------------------------------------------------------------
//   TSpectrScope (  Y)
// --------------------------------------------------------------------
//        
procedure TSpectrScope.CalcMaxY();
var wInd : integer;
begin
   fAmpMax := 0;
   if not Assigned(fArrSpectr) or (Length(fArrSpectr) = 0) then Exit;
   for wInd := Low(fArrSpectr) to High(fArrSpectr)
   do case fMode of
      smAmpMode   : if Abs(fArrSpectr[wInd].Amp) > fAmpMax
                    then fAmpMax := Abs(fArrSpectr[wInd].Amp);
      smPhaseMode : if Abs(fArrSpectr[wInd].Phs) > fAmpMax
                    then fAmpMax := Abs(fArrSpectr[wInd].Phs);
    end;
end;
// --------------------------------------------------------------------
//    Y      
procedure TSpectrScope.CalcScaleY();
begin
   fScaleY := 0;   //   Y
   if (fAmpMax <= 0) or ((fAreaFnc.Bottom - fAreaFnc.Top) <= 0)
   then Exit;
   fScaleY := (fAreaFnc.Bottom - fAreaFnc.Top) / fAmpMax;
end;
// --------------------------------------------------------------------
//         Y
function TSpectrScope.CalcFormatStringY(): string;
begin
   Result := '%5.5f';
   if (fAmpMax > 10000)
   then begin Result := '%5.0f'; Exit; end;
   if (fAmpMax >= 1000)
   then begin Result := '%5.1f'; Exit; end;
   if (fAmpMax >= 100)
   then begin Result := '%5.2f'; Exit; end;
   if (fAmpMax >= 10)
   then begin Result := '%5.3f'; Exit; end;
   if (fAmpMax >= 1)
   then begin Result := '%5.4f'; Exit; end;
   if (fAmpMax >= 0.1)
   then begin Result := '%5.5f'; Exit; end;
end;
// --------------------------------------------------------------------
//       Y
procedure TSpectrScope.BmpSubscriptAxesY();
var wYSM   : double;
    wY     : integer;
    wInd   : integer;
begin
   if (fAmpMax > 0) and (fScaleY > 0)
   then begin
      wYSM := (fAreaFnc.Bottom - fAreaFnc.Top) / SpectrMaxYMark;
      with fBMP.Canvas
      do begin
        //   
        BmpColorScheme(clWhite, clWhite, fBgColor);
        Pen.Style   := psSolid;
        Pen.Width   := 1;
        CanvasSetAngle (fBMP.Canvas, 0, 13, 'Arial');
        for wInd := 0 to SpectrMaxYMark
        do begin
          wY := fAreaAxY.Bottom - Round(wYSM  * wInd);
          MoveTo(fAreaAxY.Right - 4, wY);
          LineTo(fAreaAxY.Right,     wY);
          TextOut(fAreaAxY.Left,     wY - TextHeight('000') div 2,
                  Format(CalcFormatStringY(),[wInd*fAmpMax/10]));
        end;
      end;
   end;
end;
// --------------------------------------------------------------------
//     Y
procedure TSpectrScope.BmpShowAxesY();
begin
  BmpAreaClear(fAreaAxY, fBgColor);
  with fBMP.Canvas do
  begin
    //   
     BmpColorScheme(clWhite, clWhite, fBgColor);
    //   Y
    Pen.Style   := psSolid;
    Pen.Width   := 1;
    MoveTo(fAreaAxY.Right, fAreaAxY.Top);
    LineTo(fAreaAxY.Right, fAreaAxY.Bottom);
  end;
  BmpSubscriptAxesY();
end;
// --------------------------------------------------------------------
//   TSpectrScope (  X)
// --------------------------------------------------------------------
//    X   
procedure TSpectrScope.CalcScaleX();
begin
   fScaleX := 0;   //   X
   if (Length(fArrSpectr) <= 0) or ((fAreaFnc.Right - fAreaFnc.Left) <= 0)
   then Exit;
   fScaleX := (fAreaFnc.Right - fAreaFnc.Left) / Length(fArrSpectr);
end;
// --------------------------------------------------------------------
//       X
procedure TSpectrScope.BmpSubscriptAxesX();
var wDivStepX : integer;
    wInd      : integer;
begin
    //   
    if (fScaleX <= 0)then Exit;
    with fBMP.Canvas
    do begin
       //   
       BmpColorScheme(clWhite, clWhite, fBgColor);
       Pen.Width   := 1;
       Brush.Style := bsClear;
       //        X
       wDivStepX := 10;
       if High(fArrSpectr) <= 500  then wDivStepX := 5;
       if High(fArrSpectr) <= 100  then wDivStepX := 2;
       if High(fArrSpectr) <= 50   then wDivStepX := 1;
       //    
       CanvasSetAngle (fBMP.Canvas, 90, 11, 'Arial');
       for wInd := 0 to High(fArrSpectr)
       do begin
          if not fBWMode
          then begin
             if wInd = fSelectNum
             then Font.Color := fSelectNumColor
             else Font.Color := clWhite;
          end;
          MoveTo (fAreaAxX.Left + Round(fScaleX * wInd), fAreaAxX.Top);
          LineTo (fAreaAxX.Left + Round(fScaleX * wInd), fAreaAxX.Top + 4);
          if (wInd mod wDivStepX) = 0
          then TextOut(fAreaAxX.Left + Round(fScaleX * wInd),
                       fAreaAxX.Top  + 4 + TextWidth('000'),
                       IntToStr(wInd));
       end;
       CanvasSetAngle (fBMP.Canvas, 0, 11, 'Arial');
    end;
end;
// --------------------------------------------------------------------
//     X
procedure TSpectrScope.BmpShowAxesX();
begin
  //  
  BmpAreaClear(fAreaAxX, fBgColor);
  if fScaleX <= 0 then Exit;
  //     X
  with fBMP.Canvas do
  begin
    //   
    BmpColorScheme(clWhite, clWhite, fBgColor);
    //   X
    Pen.Style   := psSolid;
    Pen.Width   := 1;
    MoveTo(fAreaAxX.Left, fAreaAxX.Top);
    LineTo(fAreaAxX.Right, fAreaAxX.Top);
    //       X
    BmpSubscriptAxesX();
  end;
end;
// --------------------------------------------------------------------
//  TSpectrScope ( )
// --------------------------------------------------------------------
//      
procedure TSpectrScope.BmpShowSpectrLine();
var wInd, wX, wY  : integer;
begin
    //  
    if Length(fArrSpectr) <= 0 then Exit;
    if (fScaleX <= 0) or (fScaleY <= 0) then Exit;
    //     
    BmpAreaClear(fAreaFnc, fBgColor);
    with fBMP.Canvas
    do begin
       //   
       BmpColorScheme(clWhite, clWhite, fBgColor);
       Pen.Style := psSolid;
       Pen.Width := 2;
       for wInd := 0 to High(fArrSpectr)
       do begin
          wY := 0;
          case fMode of
             smAmpMode  : begin //  
                wY := fAreaFnc.Bottom - Round(fArrSpectr[wInd].Amp * fScaleY);
                if not fBWMode
                then begin
                   if wInd = fSelectNum
                   then Pen.Color := fSelectNumColor
                   else Pen.Color := fAmpColor;
                end
             end;
             smPhaseMode : begin //  
                wY := fAreaFnc.Bottom - Round(fArrSpectr[wInd].Phs * fScaleY);
                if not fBWMode
                then begin
                   if wInd = fSelectNum
                   then Pen.Color := fSelectNumColor
                   else Pen.Color := fPhsColor;
                end;   
             end;
          end;
          wX := fAreaFnc.Left + Round(fScaleX * wInd);
          //   
          MoveTo (wX + 1, wY);
          LineTo (wX + 1, fAreaFnc.Bottom);
       end;
    end;
end;

// --------------------------------------------------------------------
//   
procedure TSpectrScope.ClearShow();
begin
    BmpClear();
    BmpToImg(); //     fImg
end;

// --------------------------------------------------------------------
//          X  Y
procedure TSpectrScope.ReShow();
begin
   BmpClear();
   if Length(fArrSpectr) <= 0
   then begin
      BmpClear();
      BmpShowMsg(4, clYellow,
                '     (  )');
      //     fImg
      BmpToImg ();
      Exit;
   end;
   if (fAmpMax > 0) and (fScaleY > 0) and (fScaleX > 0)
   then begin
      try
         BmpShowAxesY();      //   Y
         BmpShowAxesX();      //   X
         BmpShowSpectrLine(); //      
         BmpShowMode();       //    (AMP/PHS)
         //      
         BmpShowMsg(2, clWhite, GrmTxtDesc(fSelectNum));
         // --------------------------------------------------
         BmpToImg(); //     fImg
         // --------------------------------------------------
      except
         MessageDlg ('    TSpectrScope'
         +  #13#10 + '      ...'
         +  #13#10 + '  ,   .',
         mtError, [mbOk], 0);
      end;
   end
   else begin
       try
          BmpShowErrorMsg('    X  Y');
          // --------------------------------------------------
          BmpToImg(); //     fImg
          // --------------------------------------------------
       except
         MessageDlg ('    TSpectrScope'
         +  #13#10 + '      ...'
         +  #13#10 + '  ,   .',
         mtError, [mbOk], 0);
      end;
   end;
end;

// --------------------------------------------------------------------
//          X  Y
procedure TSpectrScope.Show();
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpClear();
      BmpShowMsg(4, clYellow,
                '     (  )');
      //     fImg
      BmpToImg ();
      Exit;
   end;
   //  
   CalcMaxY();          //  Y -   
   CalcScaleY();        //   Y   
   CalcScaleX();        //   X   
   fSelectNum := -1;    //   
   // -------------------
   //        
   ReShow();
   // -------------------
end;
// --------------------------------------------------------------------
//   TSpectrScope ( PROPERTY)
// --------------------------------------------------------------------
//  property ArrSpectr
//   fArrSpectr     (fLoadArrSpectr) 
procedure TSpectrScope.SetArrSpectr(RqArrSpectr : TArrSpectr);
begin
   fSelectNum   := -1;        //    
   fArrSpectr := nil;         //    
   if (not Assigned(RqArrSpectr)) or (Length(RqArrSpectr) < 1)
   then begin
     BmpShowErrorMsg ('   ');
     Exit;
   end;
   //     
   // (    )
   fArrSpectr := RqArrSpectr;
   //      
   Show();
   //   "   "
   if Assigned(fOnSpectrLoad) then fOnSpectrLoad(self, fArrSpectr);
end;
// --------------------------------------------------------------------
//  property fSelectNum
procedure TSpectrScope.SetSNum(RqSNum : integer);
begin
   if (Length(fArrSpectr) <= 0) or (RqSNum < -1) or (RqSNum > High(fArrSpectr))
   then Exit;
   fSelectNum := RqSNum;
   //       
   ReShow();
   //     "  "
  if Assigned(fOnGrmSelect) then fOnGrmSelect(Self, fSelectNum, fArrSpectr);
end;
// --------------------------------------------------------------------
//  property ArrItem
//   
function  TSpectrScope.GetSelectArrItem() : TGarmonic;
begin
   FillChar(Result, SizeOF(TGarmonic), #0);
   if (Length(fArrSpectr) <= 0) or (fSelectNum < -1) or (fSelectNum > High(fArrSpectr))
   then Exit;
   Result := fArrSpectr[fSelectNum];
end;
// --------------------------------------------------------------------
//   
procedure TSpectrScope.SetSelectArrItem(RqItem : TGarmonic);
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpShowErrorMsg('   ');
      Exit;
   end;
   if (fSelectNum < -1) or (fSelectNum > High(fArrSpectr)) then Exit;
   fArrSpectr[fSelectNum] := RqItem;
   //       
   ReShow();
end;
// --------------------------------------------------------------------
//    
procedure TSpectrScope.SetXB(RqXB : double);
begin
   if (RqXB = fXB) then Exit;
   if (RqXB >= fXE)
   then begin
      MessageDlg('     ' +  #13#10
               + '    ...',
          mtError, [mbOk], 0);
      Exit;
   end;
   fXB := RqXB;
end;
// --------------------------------------------------------------------
//    
procedure TSpectrScope.SetXE(RqXE : double);
begin
   if (RqXE = fXE) then Exit;
   if (RqXE <= fXB)
   then begin
      MessageDlg('     ' +  #13#10
               + '    ...',
          mtError, [mbOk], 0);
      Exit;
   end;
   fXE := RqXE;
end;
// --------------------------------------------------------------------
//   TSpectrScope (   )
// --------------------------------------------------------------------
//   
procedure TSpectrScope.SaveToFile(RqFileName : string; RqDelimitor : char);
var wList      : TStringList;
    wInd       : integer;
    wStr       : string;
begin
  if Length(fArrSpectr) <= 0
  then begin
      BmpShowErrorMsg('   ');
      Exit;
  end;
  //   
  if FileExists(RqFileName)
  then begin
      if MessageDlg('    :'+ #13#10
                  +  RqFileName + #13#10
                  + '   ?',
                     mtInformation,[mbYes,mbNo],0) <> mrYes
      then Exit;
  end;
  try
    wList := TStringList.Create;
    //  
    wList.Add(Comment_ID  + Comment_Dlm + Spectr_ID);
    wList.Add(Comment_ID + '   : ' + DateTimeToStr(Now()));
    wList.Add(Comment_ID + Comment_Dlm + XB_ID + Comment_Dlm + FloatToStr(fXB));
    wList.Add(Comment_ID + Comment_Dlm + XE_ID + Comment_Dlm + FloatToStr(fXE));
    wList.Add(Comment_ID + '  :  Num,  Amp,  Phs(rad)');
    wList.Add(Comment_ID + ' ');
    // 
    for wInd := Low(fArrSpectr) to High(fArrSpectr) do
    begin
       // ------------------------------
       //    
       wStr := '';
       with fArrSpectr[wInd] do
       begin
         wStr := wStr + Format('%3d', [wInd])  + RqDelimitor;
         wStr := wStr + Format('%e', [Amp])    + RqDelimitor;
         wStr := wStr + Format('%e', [Phs]);
       end;
       // ------------------------------
       //  
       wList.Add(wStr);
       // ------------------------------
    end;
    wList.Add(Comment_ID + ' ');
    wList.Add(Comment_ID + ' ');
    //    
    wList.SaveToFile(RqFileName);
    // fFileName  := RqFileName;
    wList.Free;
  except
       MessageDlg('   : '
                  +   #13#10 + RqFileName,
                  mtError, [mbOk], 0);
  end;
end;
// -----------------------------------------------------------------
//       
function TSpectrScope.DialogSaveToFile() : string;
var wExt    : string;
    wDialog : TSaveDialog;
    wFileExt : string;     //   
begin
  Result := '';
  wExt   := '.txt';
  wDialog := TSaveDialog.Create(nil);
  //  
  wDialog.Filter := 'Spectr files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     wFileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (wFileExt = UpperCase(wExt))
     then Result := Result + LowerCase(wExt);
     //  
     SaveToFile(Result,  char($09));
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//  TSpectrScope (   )
// --------------------------------------------------------------------
//      
function TSpectrScope.GetSubStr(RqDelimiter : string;
                            var RqStr : string) : string;
var   wPos, wCount : integer;
begin
   Result := '';
   RqStr := Trim(RqStr);
   wPos := PosEx(RqDelimiter,RqStr);
   if wPos > 0
   then begin
      wCount := wPos - 1;
      Result :=  Copy(RqStr, 1, wCount);
      Delete(RqStr, 1, wPos);
   end
   else begin
      Result := RqStr;
      RqStr  := '';
   end;
end;
// --------------------------------------------------------------------
//  " "   XB XE  LoadFromSpectrFile
function TSpectrScope.DetectCommentAndXBXE(RqStr : string) : boolean;
var   wStr, wStrID, wStrFld : string;
      wExt : extended;
begin
   Result := False;
   wStr := Trim(RqStr);
   //    
   if Length(wStr) = 0
   then begin
        Result := True;
        Exit;
   end;
   //        X
   if Length(wStr) >= Length(Comment_ID)
   then begin
      if LeftStr(RqStr, Length(Comment_ID)) = Comment_ID
      then begin
         //   Comment_ID
         GetSubStr(Comment_Dlm, wStr);
         //   XB_ID  XE_ID
         wStrID  := GetSubStr(Comment_Dlm, wStr);
         //    XB_ID  XE_ID
         wStrFld := GetSubStr(Comment_Dlm, wStr);
         if wStrID = XB_ID
         then if TryStrToFloat(wStrFld, wExt) then fXB := wExt;
         if wStrID = XE_ID
         then if TryStrToFloat(wStrFld, wExt) then fXE := wExt;
         //    
         Result := True;
      end;
   end;
end;
// ----------------------------------------------------------------
//    
procedure TSpectrScope.LoadFromFile(RqFileName  : string;
                                    RqDelimitor : char);
var wList     : TStringList;
    Ind1      : integer;
    wStr      : string;
    wSubStr   : string;
    wInt      : integer;
    wDbl      : double;
    wErrCount : integer;
begin
   //   
   if not FileExists(RqFileName)
   then begin
       MessageDlg('   : ' +   #13#10
                 + RqFileName +   #13#10
                 + ' !    ...',
                 mtWarning, [mbOk], 0);
       Exit;
   end;
   // -------------------------------------
   //    
   wErrCount := 0;
   wList := TStringList.Create;
   try
      wList.LoadFromFile(RqFileName);
   except
      MessageDlg('   : '
      +   #13#10 + RqFileName
      +   #13#10 + '   ...',
          mtError, [mbOk], 0);
      wErrCount := 1;
   end;
   if  wErrCount > 0 then Exit;
   // -------------------------------------
   //       XB  XE
   if wList.Count > 0
   then begin
      for Ind1 := wList.Count -1 downto 0
      do if DetectCommentAndXBXE(wList.Strings[Ind1])
         then wList.Delete(Ind1);
   end;
   // -------------------------------------
   //    
   if not wList.Count > 0 then Exit;
   SetLength(fLoadArrSpectr, wList.Count);
   for Ind1 := Low(fLoadArrSpectr) to High(fLoadArrSpectr) do
   begin
      //    
      wErrCount := 0;
      wStr := wList.Strings[Ind1];
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToInt(wSubStr, wInt)
      then begin
          if Ind1 <> wInt then Inc(wErrCount);
      end else Inc(wErrCount);
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToFloat(wSubStr, wDbl)
      then fLoadArrSpectr[Ind1].Amp := wDbl
      else Inc(wErrCount);
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToFloat(wSubStr, wDbl)
      then fLoadArrSpectr[Ind1].Phs := wDbl
      else Inc(wErrCount);
      // ---------------------------
      if (wErrCount > 0)
      then begin
          MessageDlg('   =  '
                    +  IntToStr(Ind1) +  #13#10
                    + '    ...',
                    mtError, [mbOk], 0);
                   Break;
      end;
   end; // of for
   wList.Free;
   // --------------------------------
   //     X
   if fXB >= fXE then fXE := XB + MinXRange;
   //  
   if (wErrCount = 0)
   then SetArrSpectr(fLoadArrSpectr)
   else SetArrSpectr(nil);
end;
// -----------------------------------------------------------------
//       
//     (char($09))
function TSpectrScope.DialogLoadFromFile() : string;
var  wExt    : string;
     wDialog : TOpenDialog;
begin
  Result := '';
  wExt := '.txt';
  wDialog := TOpenDialog.Create(nil);
  //  
  wDialog.Filter := 'Spectr files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     LoadFromFile(Result, char($09));
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//    EXCEL
// --------------------------------------------------------------------
const SpectrBegRow = 3;   //      Excel
const SpectrBegCol = 2;   //     Excel

//     
const ArrXlsSpectr : array[0..3] of record
  S1   : string;    //    
  S2   : string;    //    
  CW   : byte;      //  
  AH   : byte;      //     
  AV   : byte;      //     
end =
(
 (S1 : '   '; S2 : '';                 CW : 16; AH : 4; AV : 2),
 (S1 : '    ';   S2 : '';               CW : 16; AH : 4; AV : 2),
 (S1 : '  ';   S2 : '     '; CW : 16; AH : 4; AV : 2),
 (S1 : '  ';   S2 : '     '; CW : 16; AH : 4; AV : 2)
);
// --------------------------------------------------------------------
//      Excel
procedure TSpectrScope.WriteToExcelSheet(XLApp : Variant);
var Sheet             : Variant;   //    Excel
    wIndR, wIndC, Ind : Integer;
begin
   //     
   Sheet := XLApp.Workbooks[1].WorkSheets[1];
   //     
   for Ind := Low(ArrXlsSpectr) to High(ArrXlsSpectr)
   do begin
     wIndC := SpectrBegCol + Ind;
     with ArrXlsSpectr[Ind] do
     begin
       Sheet.Cells[SpectrBegRow,     wIndC]:= S1;
       Sheet.Cells[SpectrBegRow + 1, wIndC]:= S2;
     end;
   end;
   //   
   wIndR := SpectrBegRow + 2;     //  
   wIndC := SpectrBegCol;
   for Ind := Low(fArrSpectr) to High(fArrSpectr) do
   begin
     with fArrSpectr[Ind] do
     begin
       Sheet.Cells[wIndR + Ind, wIndC] := Ind;         //  
       Sheet.Cells[wIndR + Ind, wIndC + 1] := Amp;     // 
       Sheet.Cells[wIndR + Ind, wIndC + 2] := Phs;     //   
       Sheet.Cells[wIndR + Ind, wIndC + 3] := Phs * 180 / Pi;
     end;
   end;
end;
// --------------------------------------------------------------------
//      Excel
procedure TSpectrScope.MarkupExcelSheet(XLApp : Variant);
var wList : Variant;   //      
    Ind   : integer;
    wInd  : integer;
begin
   //      
   wList := XLApp.Workbooks[1].WorkSheets[1].Columns;
   //     
   for Ind := Low(ArrXlsSpectr) to High(ArrXlsSpectr)
   do begin
     wInd := SpectrBegCol + Ind;
     with ArrXlsSpectr[Ind] do
     begin
      wList.Columns[wInd].ColumnWidth := CW;
      wList.Columns[wInd].HorizontalAlignment := AH;
      wList.Columns[wInd].VerticalAlignment   := AV;
     end;
   end;

end;
// --------------------------------------------------------------------
//    Excel
procedure TSpectrScope.ExportToExcel();
//   OLE unit: ComObj
const xlWorksheet = $FFFFEFB9;  //  (-4167)   
var   XLApp       : Variant;    //   Excel.Application

begin
    try
      //  OLE -   Excel
      XLApp:= CreateOleObject('Excel.Application');
      //  Excel
      XLApp.Visible := True;
      //   
      XLApp.Workbooks.Add(xlWorksheet);
      //    
      XLApp.Workbooks[1].WorkSheets[1].Name := 'SPECTR';
      //      Excel
      MarkupExcelSheet(XLApp);
      //      Excel
      WriteToExcelSheet(XLApp);
    except
      on EOleSysError
      do begin
         MessageDlg('   EXCEL'
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      on E1: EOleError
      do begin
         MessageDlg('    EXCEL'
                    + #13#10
                    + 'Excel : ' + E1.Message
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      // .  : EOleSysError, EOleError, EOleException
    end;
end;
// --------------------------------------------------------------------
//   TSpectrScope ()
// --------------------------------------------------------------------
//     
function TSpectrScope.GrmTxtDesc(RqNum : integer) : string;
const ToRad = 180/Pi;
begin
    if fSelectNum < 0
    then Result := ''
    else begin
      Result := ' Num = ' + IntToStr(fSelectNum) + ';';
      Result := Result + '  Amp = '   + FloatToStr(fArrSpectr[fSelectNum].Amp)
                       + ';';
      Result := Result + '  Phase = ' + FloatToStr(fArrSpectr[fSelectNum].Phs)
                       + ' . (';
      Result := Result +   FloatToStr(ToRad * fArrSpectr[fSelectNum].Phs)
                       + ' .)';
    end;
end;
// --------------------------------------------------------------------
//   MouseDown ( "  ")
procedure TSpectrScope.MouseDown(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
var wScale : double;
begin
  if not (Button = mbLeft) then Exit;
  if (fScaleX <= 0) or (X < fAreaAxX.Left) or (X > fAreaAxX.Right) then Exit;
  //    
  wScale := Length(fArrSpectr) / (fAreaAxX.Right - fAreaAxX.Left);
  fSelectNum := Trunc((X - fAreaAxX.Left) * wScale);
  //       
  ReShow();
  //     "  "
  if Assigned(fOnGrmSelect) then fOnGrmSelect(self, fSelectNum, fArrSpectr);
end;
// -----------------------------------------------------------------
//   
function TSpectrScope.DialogColor(RqDefColor : TColor) : TColor;
var  wDialog : TColorDialog;
begin
  Result  := RqDefColor;
  wDialog := TColorDialog.Create(nil);
  //   
  if wDialog.Execute
  then begin
      Result := wDialog.Color;
  end;
  wDialog.Free;
end;
// ------------------------------------------------------------------
//  /     
procedure TSpectrScope.DialogLoadSpectrOnOff(RqOn : boolean);
var MenuItem : TMenuItem;
begin
   //    MenuItem
   MenuItem := FindMenuItem(fPUMenu,'mLoadSpectrFromFile');
   if MenuItem <> nil then MenuItem.Enabled := RqOn;
end;
// ------------------------------------------------------------------
//    PopupMenu
procedure  TSpectrScope.GreateAndConnecPoUpMenu();
var MainItems : array of TMenuItem;
    SubItems0 : array of TMenuItem;   // 
    SubItems1 : array of TMenuItem;   // 
    SubItems2 : array of TMenuItem;   // 
    SubItems3 : array of TMenuItem;   // 
begin
   // ----------------------
   //   
   // ----------------------
   //  SubMenu0 Items
   SetLength(SubItems0,1);
   // -------
   SubItems0[0]:= NewItem(' " "', TextToShortCut(''),
                          True, True, MenuClick, 0, 'mMode');
   SubItems0[0].Tag := 100;
   SubItems0[0].Checked := False;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu1 Items
   SetLength(SubItems1,1);
   // -------
   SubItems1[0]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mLoadSpectrFromFile');
   SubItems1[0].Tag := 200;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu2 Items
   SetLength(SubItems2,2);
   // -------
   SubItems2[0]:= NewItem('   ...', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mSaveToFileAS');
   SubItems2[0].Tag := 300;
   // -------
   SubItems2[1]:= NewItem('   Excel', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mExcel');
   SubItems2[1].Tag := 301;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu3 Items
   SetLength(SubItems3,6);
   // -------
   SubItems3[0]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mBgColor');
   SubItems3[0].Tag := 400;
   // -------
   SubItems3[1]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mAmpColor');
   SubItems3[1].Tag := 401;
   // ---------
   SubItems3[2]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mPhsColor');
   SubItems3[2].Tag := 402;
   // -------
   SubItems3[3]:= NewItem('-  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mBW_Theme');
   SubItems3[3].Tag := 403;
   // -------
   // 
   SubItems3[4]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'mSeparator4');
   SubItems3[4].Tag := 0;
   // ---------
   SubItems3[5]:= NewItem('     ...',
                           TextToShortCut(''),
                           False, True, MenuClick, 0, 'mSaveImgToFile');
   SubItems3[5].Tag := 404;
   // ----------------------
   //  MainMenu Items
   // ----------------------
   SetLength(MainItems,7);
   // -------    0
   MainItems[0]:= NewSubMenu('  ',
                              0, 'mCTRL', SubItems0, True);
   // --------  
   MainItems[1]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    1
   MainItems[2]:= NewSubMenu(' ...',
                              0, 'mLoad', SubItems1, True);
   // --------  
   MainItems[3]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    2
   MainItems[4]:= NewSubMenu(' ...',
                              0, 'mSave', SubItems2, True);
   // --------  
   MainItems[5]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    3
   MainItems[6]:= NewSubMenu('',
                              0, 'mView', SubItems3, True);
   // ----------------------------
   //  PopupMenu
   fPUMenu := NewPopupMenu(fImg, 'Menu', paLeft, True, MainItems);
   //  PopupMenu
   fImg.PopupMenu := fPUMenu;

   // ----------------------------
   SetLength(SubItems0,0);
   SetLength(SubItems1,0);
   SetLength(SubItems2,0);
   SetLength(SubItems3,0);
   // ----------------------------
   SetLength(MainItems,0);
   // ----------------------------
   //  1:     ,   
   //  ShortCut     Click
   //  2:  fdImgList    
   //    RadioItem   
end;
// --------------------------------------------------------------------
//    
procedure TSpectrScope.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item  :=  TMenuItem(Sender);
   case Item.Tag of
   100 : begin  //   fMode
           if Item.Checked
           then begin
             //    
             Item.Checked := False; fMode := smAmpMode;
           end
           else begin
             //    
             Item.Checked := True;  fMode := smPhaseMode;
           end;
           //   
           Show();
         end;
   200 : begin //    
           DialogLoadFromFile();
         end;
   300 : begin //    ...
            DialogSaveToFile();
         end;
   301 : begin //    Excel
            ExportToExcel();
         end;

   400 : begin //   
            fBgColor := DialogColor(fBgColor);
            ReShow();
         end;
   401 : begin //    
            fAmpColor := DialogColor(fAmpColor);
            ReShow();
         end;
   402 : begin //    
            fPhsColor := DialogColor(fPhsColor);
            ReShow();
         end;
   403 : begin // -  
            if Item.Checked
            then fBWMode := False
            else fBWMode := True;
            Item.Checked := fBWMode;
            ReShow();
         end;
   404 : begin  //      ...
            DialogSavePicture (fImg);
         end;
   else begin end;
   end;
end;
// --------------------------------------------------------------------
//   TSpectrScope ()
// --------------------------------------------------------------------


// ====================================================================
//  TPhaseScope (   )
// ====================================================================
// --------------------------------------------------------------------
//   TPhaseScope (/)
// --------------------------------------------------------------------
constructor TPhaseScope.Create(RqPanel : TPanel);
begin
   //    ReSize
   RqPanel.Align := alNone;
   RqPanel.Anchors := [akLeft,akTop];
   //    
   if RqPanel.Width  < MinPhasePanelLen
   then RqPanel.Width  := MinPhasePanelLen;
   //    
   if RqPanel.Height < MinPhasePanelLen
   then RqPanel.Height := MinPhasePanelLen;
   //   
   if RqPanel.Width <> RqPanel.Height
   then RqPanel.Width := RqPanel.Height;
   // -----------------------------
   inherited Create;
   //  
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight := MinPhasePanelLen;
   fPanel.Constraints.MinWidth  := MinPhasePanelLen;
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX, ImgBordY,
                  fPanel.Width - 2 * ImgBordX,
                  fPanel.Height- 2 * ImgBordY);
   fImgRect := Rect(0,0, fImg.Width, fImg.Height);
   // -----------------------------
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Width  := fImg.Width;
   fBMP.Height := fImg.Height;
   // -----------------------------
   //    PopupMenu
   GreateAndConnecPoUpMenu();
   // -----------------------------
   fSelectNum     := 0;                 //    
   // -----------------------------
   //    
   CalcAreas();
   // -----------------------------
   fBgColor  := RGB(64,64,64);      //  
   fPhsColor := clLime;             //   
   fBWMode   := False;              // -  
   BmpClear();
   BmpShowMsg ('D', 4, clGray, ' .' + ' Ver.1.1.');
   //     fImg
   BmpToImg ();
   // -----------------------------
end;
// --------------------------------------------------------------------
procedure TPhaseScope.Free();
begin

    if Assigned(fPUMenu) then fPUMenu.Free;
    if Assigned(fBMP)    then fBMP.Free;
    if Assigned(fImg)    then fImg.Free;
    inherited Free;
end;
// --------------------------------------------------------------------
//         
procedure TPhaseScope.CalcAreas();
const //
      Msg_H = 18;            //   
      Msg_X = 5;             // X -   
      Msg_Y = 5;             // Y -   
      Axs_L = 20;            //       
var   Phs_H : integer;
begin
//      1
   fAreaMsgU := Rect(ImgBordX + Msg_X,
                     ImgBordY + Msg_Y,
                     fImg.Width - ImgBordX - Msg_X,
                     ImgBordY + Msg_Y + Msg_H);
   //      2
   fAreaMsgD := Rect(fAreaMsgU.Left,
                     fImg.Height - ImgBordY  - Msg_Y - Msg_H,
                     fAreaMsgU.Right,
                     fImg.Height - ImgBordY - Msg_Y);
   //   
   fZeroX := fImg.Width div 2;
   Phs_H  := fAreaMsgD.Top - fAreaMsgU.Bottom;
   fZeroY := fAreaMsgU.Bottom + Phs_H div 2;
   fVLen  := (Phs_H div 2) - Axs_L;
   //        
   fAreaAxs := Rect(fZeroX - (Phs_H div 2),
                    fZeroY - (Phs_H div 2),
                    fZeroX + (Phs_H div 2),
                    fZeroY + (Phs_H div 2));
   //    
   fAreaPHS := Rect(fZeroX - (Phs_H div 2) + Axs_L,
                    fZeroY - (Phs_H div 2) + Axs_L,
                    fZeroX + (Phs_H div 2) - Axs_L,
                    fZeroY + (Phs_H div 2) - Axs_L);
end;
// --------------------------------------------------------------------
//   TPhaseScope ( X  Y)
// --------------------------------------------------------------------
//    
procedure TPhaseScope.BmpShowAxes ();
begin
  with fBMP.Canvas do
  begin
    Pen.Mode   := pmCopy;
    Pen.Width  := 1;
    if not fBWMode
    then Pen.Color  := clWhite
    else Pen.Color  := clBlack;
    Font.Color := Pen.Color;
    Font.Name  := 'Arial';
    Font.Size  := 8;
    //   
    MoveTo(fZeroX, fAreaPHS.Top);
    LineTo(fZeroX, fAreaPHS.Bottom);
    //   
    MoveTo(fAreaPHS.Left, fZeroY);
    LineTo(fAreaPHS.Right, fZeroY);
    //    
    TextOut(fAreaPHS.Right + 2, fZeroY,  '0');
    TextOut(fZeroX, fAreaPHS.Top - TextHeight('90')- 2,   '90');
    TextOut(fAreaPHS.Left - TextWidth('180') - 2, fZeroY, '180');
    TextOut(fZeroX, fAreaPHS.Bottom + 2, '270');
  end;
end;

// --------------------------------------------------------------------
//   
procedure TPhaseScope.BmpClear();
begin
  with fBMP.Canvas do
  begin
    Brush.Style := bsSolid;
    if not fBWMode
    then Brush.Color := fBgColor
    else Brush.Color := clWhite;
    FillRect(Rect(0,0,fBMP.Width,fBMP.Height));
  end;
end;

// --------------------------------------------------------------------
//        
procedure TPhaseScope.BmpShowMsg (RqArea  : char; RqX : integer;
                                  RqColor : TColor; RqMsg : string);
var wFontColor : TColor;
    wFontSize  : integer;
begin
   with fBMP.Canvas
   do begin
     wFontColor := Font.Color;
     wFontSize  := Font.Size;
     if not fBWMode
     then Font.Color := RqColor
     else Font.Color := clBlack;
     Font.Name := 'Arial';
     Font.Size := 9;
     case RqArea of
      'U' : TextOut(fAreaMsgU.Left + RqX, fAreaMsgU.Top + 1, RqMsg);
      'D' : TextOut(fAreaMsgD.Left + RqX, fAreaMsgD.Top + 1, RqMsg);
     end;
     Font.Size  := wFontSize;
     Font.Color := wFontColor;
   end;
end;
// --------------------------------------------------------------------
//   
procedure TPhaseScope.BmpShowErrorMsg (RqMsg : string);
begin
   BmpClear ();                       //   fImg
   BmpShowMsg('D', 4, clRed, RqMsg);  //   
   BmpToImg ();                       //     fImg
end;
// --------------------------------------------------------------------
//    
procedure TPhaseScope.BmpShowGrmValue();
const ToRad = 180/Pi;
var   wStr  : string;
begin
    if (fSelectNum < Low(fArrSpectr)) or (fSelectNum > High(fArrSpectr)) then Exit;
    //   
    wStr := 'Phs = ' + FloatToStr(fArrSpectr[fSelectNum].Phs) + ' .';
    BmpShowMsg('U', 0, clWhite, wStr);
    //   
    wStr := 'Phs = ' + FloatToStr(ToRad * fArrSpectr[fSelectNum].Phs) + ' .';
    BmpShowMsg('D', 0, clWhite, wStr);
    //  
    wStr := 'Num = ' + IntToStr(fSelectNum);
    fBMP.Canvas.TextOut(ImgBordX + 5, fAreaAxs.Top, wStr);
end;
// --------------------------------------------------------------------
//     fImg
procedure TPhaseScope.BmpToImg ();
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  fImg.Canvas.CopyRect(fImgRect,fBMP.Canvas,fImgRect);
end;
// --------------------------------------------------------------------
//    
procedure TPhaseScope.Show ();
const MGrad = 180 / Pi;
var   wSin, wCos: extended;
      wPhs      : extended;
      wX, wY    : integer;
begin
  if Length(fArrSpectr) <= 0
  then begin
      BmpShowErrorMsg('   ');
      Exit;
  end;
  if (fSelectNum < Low(fArrSpectr)) or (fSelectNum > High(fArrSpectr)) then Exit;
  //   
  BmpClear();
  //  
  BmpShowAxes ();
  //   
  wPhs := fArrSpectr[fSelectNum].Phs;
  SinCos(wPhs, wSin, wCos);
  wX := fZeroX + Round(fVLen * wCos);
  wY := fZeroY - Round(fVLen * wSin);
  with fBMP.Canvas do
  begin
    //Pen.Mode  := pmCopy;
    Pen.Width := 2;
    if not fBWMode
    then Pen.Color  := fPhsColor
    else Pen.Color  := clBlack;
    MoveTo(fZeroX, fZeroY);
    LineTo(wX, wY);
  end;
  BmpShowGrmValue();
  //     fImg
  BmpToImg ();
end;

// --------------------------------------------------------------------
//   TPhaseScope ( PROPERTY)
// --------------------------------------------------------------------
//  property ArrSpectr
//   fArrSpectr    
procedure TPhaseScope.SetArrSpectr(RqArrSpectr : TArrSpectr);
begin
   fSelectNum   := -1;     //    
   fArrSpectr := nil;    //    
   if (not Assigned(RqArrSpectr)) or (Length(RqArrSpectr) < 1)
   then begin
     BmpShowErrorMsg ('   ');
     Exit;
   end;
   //     
   // (    )
   fArrSpectr := RqArrSpectr;
   fSelectNum   := 0;     //   
   //   
   Show ();
end;
// --------------------------------------------------------------------
//  property SelectGNum
procedure TPhaseScope.SetGNum(RqGNum : integer);
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpShowErrorMsg('   ');
      Exit;
   end;
   fSelectNum := -1; 
   if (Length(fArrSpectr) <= 0) or (RqGNum < -1) or (RqGNum > High(fArrSpectr))
   then Exit;
   fSelectNum := RqGNum;
   Show();
end;
// --------------------------------------------------------------------
//   TPhaseScope ()
// --------------------------------------------------------------------
//    PopupMenu
procedure TPhaseScope.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
begin
   // ----------------------------
   //     PopupMenu
   SetLength(MenuItems, 4);
   // ---------
   MenuItems[0]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mBgColor');
   MenuItems[0].Tag := 1;
   // ---------
   MenuItems[1]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mPhsColor');
   MenuItems[1].Tag := 2;
   // ---------
   MenuItems[2]:= NewItem('-  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'BW_Theme');
   MenuItems[2].Tag := 3;
   // ---------
   MenuItems[3]:= NewItem('     ...',
                          TextToShortCut(''),
                          False, True, MenuClick, 0, 'mSaveImgToFile');
   MenuItems[3].Tag := 4;
   // ----------------------------
   //  PopupMenu
   fPUMenu := NewPopupMenu(fImg, 'Menu', paLeft, True, MenuItems);
   //  PopupMenu
   fImg.PopupMenu := fPUMenu;
   // ----------------------------
   //     PopupMenu
   SetLength(MenuItems,0);
end;
// -----------------------------------------------------------------
//   
function TPhaseScope.DialogColor(RqDefColor : TColor) : TColor;
var  wDialog : TColorDialog;
begin
  Result  := RqDefColor;
  wDialog := TColorDialog.Create(nil);
  //   
  if wDialog.Execute
  then begin
      Result := wDialog.Color;
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//    
procedure TPhaseScope.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item  :=  TMenuItem(Sender);
   case Item.Tag of
   1 : begin  //   
          fBgColor := DialogColor(fBgColor);
          Show();
       end;
   2 : begin  //    
          fPhsColor := DialogColor(fPhsColor);
          Show();
       end;
   3 : begin // -  
          if Item.Checked
          then fBWMode  := False
          else fBWMode  := True;
          Item.Checked := fBWMode;
          Show();
       end;
   4 : begin  //    
          DialogSavePicture (fImg);
       end;
   end;
end;
// --------------------------------------------------------------------
//   TPhaseScope ()
// --------------------------------------------------------------------

// ====================================================================
//  TSignalScope ( )
// ====================================================================
// --------------------------------------------------------------------
//   TPhaseScope (/)
// --------------------------------------------------------------------
constructor TSignalScope.Create(RqPanel : TPanel);
begin
   // -----------------------------
   inherited Create;
   //  
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight := MinSpectrPanelHeight;
   fPanel.Constraints.MinWidth  := MinSpectrPanelWidth;
   //    ReSize
   if fPanel.Align = alNone
   then  fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   // -----------------------------
   fOnSignalDestroy := nil;
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX, ImgBordY,
                  fPanel.Width - 2 * ImgBordX,
                  fPanel.Height- 2 * ImgBordY);
   fImgRect := Rect(0,0, fImg.Width, fImg.Height);
   //  
   fImg.OnMouseMove := MouseMove;
   fMouseX    := 0;                    // Pix -    fImg
   fRulerStop := False;                //   
   // -----------------------------
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Width  := fImg.Width;
   fBMP.Height := fImg.Height;
   // -----------------------------
   //    PopupMenu
   GreateAndConnecPopUpMenu();
   // -----------------------------
   //    
   CalcAreas();
   // -----------------------------
   fNumPnt   := 1024;                  //    
   fXB       := -1;
   fXE       :=  1;
   // -----------------------------
   SetLength(fArrSignal, fNumPnt);     //   
   // -----------------------------
   fBgColor      := RGB(64,64,64);     //  
   fSignalColor  := clLime;            //   
   fBWMode       := False;             // -  

   BmpClear();
   BmpShowMsg (4, clGray, ' .' + ' Ver.1.1.');
   // -----------------------------
   //   -  
   // BmpAreaClear(fAreaAxY, RGB(100, 60, 60));
   // BmpAreaClear(fAreaFnc, RGB(60, 100, 60));
   // BmpAreaClear(fAreaAxX, RGB(60, 60, 100));
   // BmpAreaClear(fAreaMsg, RGB(60, 100, 100));
   // -----------------------------
   //     fImg
   BmpToImg ();
   // -----------------------------
   //    ReSize
   fTimer          := TTimer.Create(nil);
   fTimer.Enabled  := False;
   fTimer.OnTimer  := onReSizeTimer;
   fTimer.Interval := TimeReSizeOut;
   // -----------------------------
   fPanel.OnResize := OnPanelResize;
end;
// --------------------------------------------------------------------
procedure TSignalScope.Free();
begin
    fPanel.OnResize := nil;
    if Assigned(fTimer) then fTimer.Free;
    //   "   Free"
    if Assigned(fOnSignalDestroy) then fOnSignalDestroy(Self);
    SetLength(fArrSignal, 0);           //   
    if Assigned(fPUMenu) then fPUMenu.Free;
    if Assigned(fBMP)    then fBMP.Free;
    if Assigned(fImg)    then fImg.Free;
    inherited Free;
end;
// --------------------------------------------------------------------
//  TSignalScope  ReSize
// --------------------------------------------------------------------
//   Resize  
procedure TSignalScope.onPanelResize(Sender: TObject);
begin
   if fImg.Visible
   then begin
       fImg.Visible := False;
       fTimer.Enabled := True;
   end;
   fTimer.Interval := TimeReSizeOut;
end;
// --------------------------------------------------------------------
//     ReSize
procedure TSignalScope.onReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled := False;
   ReSize;
end;
// --------------------------------------------------------------------
//   SpectrScope     
procedure TSignalScope.ReSize();
begin
   // -----------------------------
   if fImg.Visible then fImg.Visible := False;
   with fImg do
   begin
      Picture.Bitmap.Width  := fPanel.Width  - 2 * ImgBordX;
      Picture.Bitmap.Height := fPanel.Height - 2 * ImgBordY;
      fBMP.Width  :=  Picture.Bitmap.Width;
      fBMP.Height :=  Picture.Bitmap.Height;
      Width  :=  Picture.Bitmap.Width;
      Height :=  Picture.Bitmap.Height;
   end;
   fImgRect := Rect(0,0, fImg.Width, fImg.Height);
   CalcAreas();
   Show;
   fImg.Visible := True;
   // -----------------------------
end;
// --------------------------------------------------------------------
//  TSignalScope (    )
// --------------------------------------------------------------------
//     
procedure TSignalScope.CalcAreas();
const
      AreasX  = 5;      //     X
      AreasY  = 8;      //     Y
      Mod_W   = 50;     //    fAreaMsg  fAreaAxY
      Mod_H   = 20;     //    fAreaMod
      Msg_H   = Mod_H;  //    fAreaMsg
      AxX_H   = 32;     //    fAreaAxX
begin
   //    
   fAreaMod := Rect(ImgBordX    + AreasX,
                    fImg.Height - ImgBordY - Mod_H,
                    ImgBordX    + Mod_W,
                    fImg.Height - ImgBordY);
   //     
   fAreaMsg := Rect(fAreaMod.Right + 1,
                    fImg.Height - ImgBordY - Msg_H,
                    fImg.Width  - AreasX - ImgBordX,
                    fImg.Height - ImgBordY);
   //    X
   fAreaAxX  := Rect(fAreaMod.Right + 1,
                    fAreaMsg.Top  - 1 - AxX_H,
                    fImg.Width    - AreasX - ImgBordX,
                    fAreaMsg.Top  - 1);
   //   
   fAreaFnc  := Rect(fAreaMod.Right + 1,
                    ImgBordY + AreasY,
                    fImg.Width    - AreasX - ImgBordX,
                    fAreaAxX.Top   - 1);
   //    Y
   fAreaAxY  := Rect(ImgBordX + AreasX,
                    ImgBordY + AreasY,
                    fAreaFnc.Left - 1,
                    fAreaFnc.Bottom);
   //    Y   fBMP
   fZeroY := fAreaFnc.Top + Round((fAreaFnc.Bottom - fAreaFnc.Top) / 2);
end;
// --------------------------------------------------------------------
//   
procedure TSignalScope.BmpColorScheme(FontColor, PenColor, BrushColor : TColor);
begin
  with fBMP.Canvas do
  begin
    if not fBWMode
    then begin
      Font.Color  := FontColor;
      Pen.Color   := PenColor;
      Brush.Color := BrushColor;
    end
    else begin
      //  -   
      Font.Color  := clBlack;
      Pen.Color   := clBlack;
      Brush.Color := clWhite;
    end;
  end;
end;
// --------------------------------------------------------------------
//   
procedure TSignalScope.BmpClear();
begin
  with fBMP.Canvas do
  begin
    Brush.Style := bsSolid;
    BmpColorScheme(clWhite, clWhite, fBgColor);
    FillRect(Rect(0,0,fBMP.Width,fBMP.Height));
  end;
end;
// --------------------------------------------------------------------
//    
procedure TSignalScope.BmpAreaClear (RqArea : TRect; RqColor : TColor);
begin
  with fBMP.Canvas do
  begin
    Brush.Style := bsSolid;
    BmpColorScheme(clWhite, clWhite, RqColor);
    FillRect(Rect(RqArea.Left, RqArea.Top, RqArea.Right + 1, RqArea.Bottom +1));
  end;
end;
// --------------------------------------------------------------------
//     
procedure TSignalScope.BmpShowMsg (RqX : integer; RqColor : TColor;
                                   RqMsg : string);
begin
   BmpAreaClear(fAreaMsg, fBgColor);
   with fBMP.Canvas
   do begin
     BmpColorScheme(RqColor, clWhite, fBgColor);
     Font.Name := 'Arial';
     Font.Size := 9;
     TextOut(fAreaMsg.Left + RqX , fAreaMsg.Top, RqMsg);
   end;
end;
// --------------------------------------------------------------------
//   
procedure TSignalScope.BmpShowErrorMsg (RqMsg : string);
begin
   BmpClear ();                     //   fImg
   BmpShowMsg(4, clRed, RqMsg);     //   
   BmpToImg ();                     //     fImg
end;
// --------------------------------------------------------------------
//   TSignalScope (  Y)
// --------------------------------------------------------------------
// --------------------------------------------------------------------
//         Y
function TSignalScope.CalcFormatStringY(): string;
begin
   Result := '%5.5f';
   if (fMaxAbsS > 10000)
   then begin Result := '%5.0f'; Exit; end;
   if (fMaxAbsS >= 1000)
   then begin Result := '%5.1f'; Exit; end;
   if (fMaxAbsS >= 100)
   then begin Result := '%5.2f'; Exit; end;
   if (fMaxAbsS >= 10)
   then begin Result := '%5.3f'; Exit; end;
   if (fMaxAbsS >= 1)
   then begin Result := '%5.4f'; Exit; end;
   if (fMaxAbsS >= 0.1)
   then begin Result := '%5.5f'; Exit; end;
end;

// --------------------------------------------------------------------
//       Y
procedure TSignalScope.BmpSubscriptAxesY();
const WMaxYMark = 5;
var wYSM   : double;
    wY     : integer;
    wInd   : integer;
begin
   if (fMaxAbsS > 0)
   then begin
      wYSM := (fAreaFnc.Bottom - fAreaFnc.Top) / wMaxYMark / 2;
      BmpColorScheme(clWhite, clWhite, fBgColor);
      CanvasSetAngle (fBMP.Canvas, 0, 13, 'Arial');
      with fBMP.Canvas do
      begin
        for wInd := 0 to wMaxYMark
        do begin
          wY := fZeroY - Round(wYSM  * wInd);
          MoveTo(fAreaAxY.Right - 4, wY);
          LineTo(fAreaAxY.Right,     wY);
          TextOut(fAreaAxY.Left,     wY - TextHeight('000') div 2,
                  Format(CalcFormatStringY(),[wInd * fMaxAbsS / WMaxYMark]));
          wY := fZeroY + Round(wYSM  * wInd);
          MoveTo(fAreaAxY.Right - 4, wY);
          LineTo(fAreaAxY.Right,     wY);
          TextOut(fAreaAxY.Left,     wY - TextHeight('000') div 2,
                  Format(CalcFormatStringY(),[wInd * fMaxAbsS / WMaxYMark]));
        end;
      end;
   end;
end;
// --------------------------------------------------------------------
//     Y
procedure TSignalScope.BmpShowAxesY();
begin
  //    Y
  BmpAreaClear(fAreaAxY, fBgColor);
  with fBMP.Canvas do
  begin
    //   Y
    Pen.Style   := psSolid;
    Pen.Width   := 1;
    BmpColorScheme(clWhite, clWhite, fBgColor);
    MoveTo(fAreaAxY.Right, fAreaAxY.Top);
    LineTo(fAreaAxY.Right, fAreaAxY.Bottom);
  end;
  BmpSubscriptAxesY();
end;
// --------------------------------------------------------------------
//   TSignalScope (  X)
// --------------------------------------------------------------------
// --------------------------------------------------------------------
//     X
procedure TSignalScope.BmpShowAxesX();
var wInd, wX  : integer;
    wDivStepX : integer;
begin
  with fBMP.Canvas do
  begin
    //   X    
    Pen.Style   := psSolid;
    Pen.Width   := 1;
    BmpColorScheme(clWhite, clWhite, fBgColor);
    //   X    fAreaFnc
    MoveTo(fAreaFnc.Left,  fZeroY);
    LineTo(fAreaFnc.Right, fZeroY);
    //    X
    MoveTo(fAreaAxX.Left,  fAreaAxX.Top);
    LineTo(fAreaAxX.Right, fAreaAxX.Top);
    //  .       X
    fPntStepX := (fAreaAxX.Right - fAreaAxX.Left) / (fNumPnt - 1);
    //        X
    wDivStepX := 200;
    if fNumPnt <= 2048 then wDivStepX := 100;
    if fNumPnt <= 1024 then wDivStepX := 50;
    if fNumPnt <= 512  then wDivStepX := 20;
    if fNumPnt <= 128  then wDivStepX := 5;
    if fNumPnt <= 64   then wDivStepX := 2;
    //   90    
    CanvasSetAngle (fBMP.Canvas, 90, 11, 'Arial');
    //        X
    for wInd := 0 to (fNumPnt div wDivStepX) - 1
    do begin
       wX := fAreaAxX.Left + Round(fPntStepX * wInd  * wDivStepX);
       MoveTo(wX,  fAreaAxX.Top);
       LineTo(wX,  fAreaAxX.Top + 4);
       TextOut(wX, fAreaAxX.Top  + 4 + TextWidth('0000'),
               IntToStr(wInd * wDivStepX));
    end;
    CanvasSetAngle (fBMP.Canvas, 0, 11, 'Arial');
  end;
end;
// --------------------------------------------------------------------
//   
procedure TSignalScope.BmpShowSig();
var wIndS   : integer;
    wX, wY  : integer;
    wStepX  : double;
begin
   //    
   BmpAreaClear(fAreaFnc, fBgColor);
   //  
   if (Length(fArrSignal) < 2) or (fYToPixY < 0) then Exit;
   wStepX := (fAreaFnc.Right - fAreaFnc.Left) / High(fArrSignal);
   //    () 
   with fBMP.Canvas do
   begin
      Pen.Style   := psSolid;
      Pen.Width   := 1;
      //   X  
      BmpColorScheme(clWhite, clWhite, fBgColor);
      MoveTo(fAreaFnc.Left,  fZeroY);
      LineTo(fAreaFnc.Right, fZeroY);
      //    () 
      BmpColorScheme(clWhite, fSignalColor, fBgColor);
      for wIndS := Low(fArrSignal) to High(fArrSignal)
      do begin
         wX  := fAreaFnc.Left + Round(wStepX * wIndS);
         wY  := fZeroY - Round(fYToPixY * fArrSignal[wIndS]);
         if wIndS = Low(fArrSignal)
         then MoveTo(wX, wY)
         else LineTo(wX, wY);
      end;
   end;
end;
// --------------------------------------------------------------------
//     fImg
procedure TSignalScope.BmpToImg ();
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  fImg.Canvas.CopyRect(fImgRect,fBMP.Canvas,fImgRect);
end;
// --------------------------------------------------------------------
//     
procedure TSignalScope.BmpShow ();
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpShowErrorMsg('   ');
      Exit;
   end;
   // ----------------
   //  
   BmpClear();
   //   X
   BmpShowAxesX();
   //   Y
   BmpShowAxesY();
   //  
   BmpShowSig();
   //  
   BmpShowRuler([ssLeft], fMouseX, 0);
   //       
   BmpSPointInfo(fArrIndx);
   // ----------------
   //     fImg
   BmpToImg ();
end;

// --------------------------------------------------------------------
//        
procedure TSignalScope.ReShow ();
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpShowErrorMsg('   ');
      Exit;
   end;
   //   
   CreateSignal();
   //     
   BmpShow ();
end;

// --------------------------------------------------------------------
//        
procedure TSignalScope.Show ();
begin
   if Length(fArrSpectr) <= 0
   then begin
      BmpShowErrorMsg('   ');
      Exit;
   end;
   //   
   CreateSignal();
   //  .  Y     Y
   CalcYToPixY();
   //     
   BmpShow ();
   //   "     "
   if Assigned(fOnSignalReady) then fOnSignalReady(self, fArrSignal);
end;
// --------------------------------------------------------------------
//   TSignalScope ( )
// --------------------------------------------------------------------
//  .  Y     Y
procedure TSignalScope.CalcYToPixY();
var wInd         : integer;
    wSignal      : double;
    wMinY, wMaxY : double;
begin
   wMinY    := 0;
   wMaxY    := 0;
   for wInd := Low(fArrSignal) to High(fArrSignal)
   do begin
     wSignal := fArrSignal[wInd];
     //      
     if wSignal < wMinY then wMinY := wSignal;
     if wSignal > wMaxY then wMaxY := wSignal;
   end;
   //    
   if Abs(wMaxY) > Abs(wMinY)
   then fMaxAbsS := Abs(wMaxY)
   else fMaxAbsS := Abs(wMinY);
   //  .  Y     Y
   if fMaxAbsS > 0
   then fYToPixY := ((fAreaFnc.Bottom - fAreaFnc.Top) / 2) / fMaxAbsS
   else fYToPixY := 0;
end;
// --------------------------------------------------------------------
//   
procedure TSignalScope.CreateSignal();
const cEps = 1e-10;
var wIndS, wIndG : integer;
    wXToPhs : double;
    wStepX  : double;
    wX      : double;
    wPhase  : double;
    wSignal : double;
begin
   // 
   if (not Assigned(fArrSpectr))   or
      (Length(fArrSpectr)    < 1)  or
      (Length(fArrSignal)    < 2)  then Exit;
   if (fXE < fXB) then Exit;
   if Abs(fXE - fXB) < cEps then fXE := fXB + cEps;
   //  
   wXToPhs := 2 * Pi /(fXE - fXB);
   // .  X -   
   wStepX  := (fXE - fXB) / High(fArrSignal);
   //    () 
   for wIndS := Low(fArrSignal) to High(fArrSignal)
   do begin
       wX := fXB + wStepX * wIndS;
       wSignal := 0;
       for wIndG := Low(fArrSpectr) to High(fArrSpectr)
       do begin
          wPhase  := wXToPhs * wIndG * wX + fArrSpectr[wIndG].Phs;
          if wIndG = Low(fArrSpectr)
          then wSignal := fArrSpectr[wIndG].Amp
          else wSignal := wSignal + fArrSpectr[wIndG].Amp * Sin(wPhase);
       end;
       fArrSignal[wIndS] := wSignal;
   end;
end;
// --------------------------------------------------------------------
//   TSignalScope ( PROPERTY)
// --------------------------------------------------------------------
//       
// property SignalNumPnt
procedure TSignalScope.SetArrNumPnt(RqNumPnt : integer);
begin
   if not ((RqNumPnt >= 32) and (RqNumPnt <= 4096))
   then begin
      MessageDlg('    .'
      +   #13#10 + '   32  4096 ...',
          mtError, [mbOk], 0);
      Exit;
   end;
   //  
   ReStartRuler();
   //   
   SetLength(fArrSignal, RqNumPnt);
   fNumPnt := RqNumPnt;
   //     ,   
   if Assigned(fArrSpectr)
   then if (Length(fArrSpectr) > 0) then Show();
end;
// --------------------------------------------------------------------
//    
procedure TSignalScope.SetXB(RqXB : double);
begin
   if (RqXB = fXB) then Exit;
   if (RqXB >= fXE)
   then begin
      MessageDlg('     ' +  #13#10
               + '    ...',
          mtError, [mbOk], 0);
      Exit;
   end;
   fXB := RqXB;
   //  
   ReStartRuler();
   //     ,   
   if Assigned(fArrSpectr)
   then if (Length(fArrSpectr) > 0) then Show();
end;
// --------------------------------------------------------------------
//    
procedure TSignalScope.SetXE(RqXE : double);
begin
   if (RqXE = fXE) then Exit;
   if (RqXE <= fXB)
   then begin
      MessageDlg('     ' +  #13#10
               + '    ...',
          mtError, [mbOk], 0);
      Exit;
   end;
   fXE := RqXE;
   //  
   ReStartRuler();
   //     ,   
   if Assigned(fArrSpectr)
   then if (Length(fArrSpectr) > 0) then Show();
end;
// --------------------------------------------------------------------
//     
// property ArrSpectr
procedure TSignalScope.SetArrSpectr(RqArrSpectr : TArrSpectr);
begin
   fArrSpectr := nil;                          //    
   //     
   if (not Assigned(RqArrSpectr)) or (Length(RqArrSpectr) < 1)
   then begin
     BmpShowErrorMsg ('   ');
     Exit;
   end;
   // ----------------
   //     
   // (    )
   fArrSpectr := RqArrSpectr;
   // ----------------
   //  
   ReStartRuler();
   //     
   Show();
   //   "   "
   if Assigned(fOnSpectrLoad) then fOnSpectrLoad(self, fArrSpectr);
end;
// --------------------------------------------------------------------
//  TSignalScope (   )
// --------------------------------------------------------------------
//  " "   XB XE  LoadFromSpectrFile
function TSignalScope.DetectCommentAndXBXE(RqStr : string) : boolean;
var   wStr, wStrID, wStrFld : string;
      wExt : extended;
begin
   Result := False;
   wStr := Trim(RqStr);
   //    
   if Length(wStr) = 0
   then begin
        Result := True;
        Exit;
   end;
   //        X
   if Length(wStr) >= Length(Comment_ID)
   then begin
      if LeftStr(RqStr, Length(Comment_ID)) = Comment_ID
      then begin
         //   Comment_ID
         GetSubStr(Comment_Dlm, wStr);
         //   XB_ID  XE_ID
         wStrID  := GetSubStr(Comment_Dlm, wStr);
         //    XB_ID  XE_ID
         wStrFld := GetSubStr(Comment_Dlm, wStr);
         if wStrID = XB_ID
         then if TryStrToFloat(wStrFld, wExt) then fXB := wExt;
         if wStrID = XE_ID
         then if TryStrToFloat(wStrFld, wExt) then fXE := wExt;
         //    
         Result := True;
      end;
   end;
end;
// --------------------------------------------------------------------
//      
function TSignalScope.GetSubStr(RqDelimiter : string; var RqStr : string) : string;
var   wPos, wCount : integer;
begin
   Result := '';
   RqStr := Trim(RqStr);
   wPos := PosEx(RqDelimiter,RqStr);
   if wPos > 0
   then begin
      wCount := wPos - 1;
      Result :=  Copy(RqStr, 1, wCount);
      Delete(RqStr, 1, wPos);
   end
   else begin
      Result := RqStr;
      RqStr  := '';
   end;
end;
// ----------------------------------------------------------------
//    
procedure TSignalScope.LoadFromSpectrFile(RqFileName  : string;
                                          RqDelimitor : char);
var wList     : TStringList;
    Ind1      : integer;
    wStr      : string;
    wSubStr   : string;
    wInt      : integer;
    wDbl      : double;
    wErrCount : integer;
begin
   //   
   if not FileExists(RqFileName)
   then begin
       MessageDlg('   : ' +   #13#10
                 + RqFileName +   #13#10
                 + ' !    ...',
                 mtWarning, [mbOk], 0);
       Exit;
   end;
   // -------------------------------------
   //    
   wErrCount := 0;
   wList := TStringList.Create;
   try
      wList.LoadFromFile(RqFileName);
   except
      MessageDlg('   : '
      +   #13#10 + RqFileName
      +   #13#10 + '   ...',
          mtError, [mbOk], 0);
      wErrCount := 1;
   end;
   if  wErrCount > 0 then Exit;
   // -------------------------------------
   //       XB  XE
   if wList.Count > 0
   then begin
      for Ind1 := wList.Count -1 downto 0
      do if DetectCommentAndXBXE(wList.Strings[Ind1])
         then wList.Delete(Ind1);
   end;
   // -------------------------------------
   //    
   if not wList.Count > 0 then Exit;
   SetLength(fLoadArrSpectr, wList.Count);
   for Ind1 := Low(fLoadArrSpectr) to High(fLoadArrSpectr) do
   begin
      //    
      wErrCount := 0;
      wStr := wList.Strings[Ind1];
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToInt(wSubStr, wInt)
      then begin
          if Ind1 <> wInt then Inc(wErrCount);
      end else Inc(wErrCount);
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToFloat(wSubStr, wDbl)
      then fLoadArrSpectr[Ind1].Amp := wDbl
      else Inc(wErrCount);
      // ---------------------------
      //   
      wSubStr := GetSubStr(RqDelimitor, wStr);
      if TryStrToFloat(wSubStr, wDbl)
      then fLoadArrSpectr[Ind1].Phs := wDbl
      else Inc(wErrCount);
      // ---------------------------
      if (wErrCount > 0)
      then begin
          MessageDlg('   =  '
                    +  IntToStr(Ind1) +  #13#10
                    + '    ...',
                    mtError, [mbOk], 0);
                   Break;
      end;
   end; // of for
   wList.Free;
   // --------------------------------
   //     X
   if fXB >= fXE then fXE := XB + MinXRange;
   //  
   if (wErrCount = 0)
   then SetArrSpectr(fLoadArrSpectr)
   else SetArrSpectr(nil);
end;
// -----------------------------------------------------------------
//       
//     (char($09))
function TSignalScope.DialogLoadFromSpecrtFile() : string;
var  wExt    : string;
     wDialog : TOpenDialog;
begin
  Result := '';
  wExt := '.txt';
  wDialog := TOpenDialog.Create(nil);
  //  
  wDialog.Filter := 'Spectr files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     LoadFromSpectrFile(Result, Data_Dlm);
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//   TSignalScope (   )
// --------------------------------------------------------------------
//   
procedure TSignalScope.SaveToFile(RqFileName : string; RqDelimitor : char);
var wList      : TStringList;
    wInd       : integer;
    wStr       : string;
    wX         : double;
begin
  if Length(fArrSpectr) <= 0
  then begin
      BmpShowErrorMsg('   ');
      Exit;
  end;
  if Length(fArrSignal) <= 0
  then begin
      BmpShowErrorMsg('   ');
      Exit;
  end;
  //   
  if FileExists(RqFileName)
  then begin
      if MessageDlg('    :'+ #13#10
                  +  RqFileName + #13#10
                  + '   ?',
                     mtInformation,[mbYes,mbNo],0) <> mrYes
      then Exit;
  end;
  try
    wList := TStringList.Create;
    //  
    wList.Add(Comment_ID + '  Ver 1.01.');
    wList.Add(Comment_ID + '   : ' + DateTimeToStr(Now()));
    wList.Add(Comment_ID + Comment_Dlm + XB_ID + Comment_Dlm + FloatToStr(fXB));
    wList.Add(Comment_ID + Comment_Dlm + XE_ID + Comment_Dlm + FloatToStr(fXE));
    wList.Add(Comment_ID + '  :  Num,  X,  Y');
    wList.Add(Comment_ID);
    // 
    for wInd := Low(fArrSignal) to High(fArrSignal) do
    begin
       // ------------------------------
       //    
       wStr := '';
       wX   := fXB + wInd * (fXE - fXB) / High(fArrSignal);
       wStr := wStr + Format('%3d', [wInd])  + RqDelimitor;
       wStr := wStr + Format('%e',  [wX])    + RqDelimitor;
       wStr := wStr + Format('%e',  [fArrSignal[wInd]]);
       // ------------------------------
       //  
       wList.Add(wStr);
       // ------------------------------
    end;
    wList.Add(Comment_ID);
    wList.Add(Comment_ID + ' ');
    //    
    wList.SaveToFile(RqFileName);
    wList.Free;
  except
       MessageDlg('   : '
                  +  #13#10 + RqFileName,
                  mtError, [mbOk], 0);
  end;
end;
// -----------------------------------------------------------------
//       
function TSignalScope.DialogSaveToFile() : string;
var wExt    : string;
    wDialog : TSaveDialog;
    wFileExt : string;     //   
begin
  Result := '';
  wExt   := '.txt';
  wDialog := TSaveDialog.Create(nil);
  //  
  wDialog.Filter := 'Signal files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     wFileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (wFileExt = UpperCase(wExt))
     then Result := Result + LowerCase(wExt);
     //  
     SaveToFile(Result,  Data_Dlm);
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//  TSignalScope (   EXCEL)
// --------------------------------------------------------------------
const SignalBegRow = 3;   //      Excel
const SignalBegCol = 2;   //     Excel

//     
const ArrXlsSignal : array[0..2] of record
  S1   : string;    //    
  S2   : string;    //    
  CW   : byte;      //  
  AH   : byte;      //     
  AV   : byte;      //       
end =
(
 (S1 : '       ';  S2 : '         ';  CW : 16; AH : 4; AV : 2),
 (S1 : '     ';  S2 : '      X        ';  CW : 16; AH : 4; AV : 2),
 (S1 : '     ';  S2 : '      Y        ';  CW : 16; AH : 4; AV : 2)
);
// --------------------------------------------------------------------
//      Excel
procedure TSignalScope.WriteToExcelSheet(XLApp : Variant);
var Sheet             : Variant;   //    Excel
    wIndR, wIndC, Ind : Integer;
    wX                : double;
begin
   //     
   Sheet := XLApp.Workbooks[1].WorkSheets[1];
   //     
   for Ind := Low(ArrXlsSignal) to High(ArrXlsSignal)
   do begin
     wIndC := SpectrBegCol + Ind;
     with ArrXlsSignal[Ind] do
     begin
       Sheet.Cells[SpectrBegRow,     wIndC]:= S1;
       Sheet.Cells[SpectrBegRow + 1, wIndC]:= S2;
     end;
   end;
   //   
   wIndR := SignalBegRow + 2;     //  
   wIndC := SignalBegCol;
   for Ind := Low(fArrSignal) to High(fArrSignal) do
   begin
      wX := fXB + Ind * (fXE - fXB) / High(fArrSignal);
      Sheet.Cells[wIndR + Ind, wIndC]     := Ind;              //  
      Sheet.Cells[wIndR + Ind, wIndC + 1] := wX;               // X
      Sheet.Cells[wIndR + Ind, wIndC + 2] := fArrSignal[Ind];  // Y
   end;
end;
// --------------------------------------------------------------------
//      Excel
procedure TSignalScope.MarkupExcelSheet(XLApp : Variant);
var wList : Variant;   //      
    Ind   : integer;
    wInd  : integer;
begin
   //      
   wList := XLApp.Workbooks[1].WorkSheets[1].Columns;
   //     
   for Ind := Low(ArrXlsSignal) to High(ArrXlsSignal)
   do begin
     wInd := SignalBegCol + Ind;
     with ArrXlsSignal[Ind] do
     begin
      wList.Columns[wInd].ColumnWidth := CW;
      wList.Columns[wInd].HorizontalAlignment := AH;
      wList.Columns[wInd].VerticalAlignment   := AV;
     end;
   end;

end;
// --------------------------------------------------------------------
//    Excel
procedure TSignalScope.ExportToExcel();
//   OLE unit: ComObj
const xlWorksheet = $FFFFEFB9;  //  (-4167)   
var   XLApp       : Variant;    //   Excel.Application

begin
    try
      //  OLE -   Excel
      XLApp:= CreateOleObject('Excel.Application');
      //  Excel
      XLApp.Visible := True;
      //   
      XLApp.Workbooks.Add(xlWorksheet);
      //    
      XLApp.Workbooks[1].WorkSheets[1].Name := 'SIGNAL';
      //      Excel
      MarkupExcelSheet(XLApp);
      //      Excel
      WriteToExcelSheet(XLApp);
    except
      on EOleSysError
      do begin
         MessageDlg('   EXCEL'
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      on E1: EOleError
      do begin
         MessageDlg('    EXCEL'
                    + #13#10
                    + 'Excel : ' + E1.Message
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      // .  : EOleSysError, EOleError, EOleException
    end;
end;
// --------------------------------------------------------------------
//   TSignalScope ()
// --------------------------------------------------------------------
// --------------------------------------------------------------------
//       
procedure TSignalScope.BmpSPointInfo(RqArrIndx : integer);
var wStr : string;
begin
    //   
    BmpAreaClear(fAreaMsg, fBgColor);
    if RqArrIndx < 0 then Exit;
    //  
    if Abs(fXE - fXB) > 0
    then fScaleX := (fXE - fXB) / High(fArrSignal)
    else fScaleX := 0;
    Wstr := 'Index = ' + IntToStr(RqArrIndx)
           + ';   X = ' + FloatToStr(fXB + fScaleX * RqArrIndx)
           + ';   Y = ' + FloatToStr(fArrSignal[RqArrIndx]);
    //  
    BmpShowMsg(0, clWhite, wStr);
end;
// --------------------------------------------------------------------
//  
procedure TSignalScope.BmpShowRuler(Shift: TShiftState; X, Y: Integer);
begin
   if not ((X >= fAreaAxX.Left) and (X <= fAreaAxX.Right))then Exit;
   with fBMP.Canvas do
   begin
       //  
       Pen.Width   := 1;
       BmpColorScheme(clWhite, clWhite, fBgColor);
       MoveTo(X, fAreaFnc.Top);
       LineTo(X, fAreaFnc.Bottom);
   end;
end;
// --------------------------------------------------------------------
//  X - mouse    
procedure TSignalScope.MouseXToArrIndx(RqX : integer);
begin
   fArrIndx := -1;
   if (Length(fArrSignal) < 2) or (RqX  < fAreaFnc.Left) or (RqX  > fAreaFnc.Right)
   then Exit;
   fArrIndx := Round((RqX - fAreaFnc.Left)
                   *  High(fArrSignal)
                   / (fAreaFnc.Right - fAreaFnc.Left));
end;
// --------------------------------------------------------------------
//  
procedure TSignalScope.ReStartRuler();
var MenuItem : TMenuItem;
begin
   fRulerStop := False;
   fMouseX    := fAreaFnc.Left;
   fArrIndx   := 0;
   //    MenuItem
   MenuItem := FindMenuItem(fPUMenu,'mRulerStop');
   if MenuItem <> nil then MenuItem.Checked := False;
end;
// --------------------------------------------------------------------
//     ( fImg.onMouseMove)
procedure TSignalScope.MouseMove(Sender: TObject;
                                 Shift: TShiftState; X, Y: Integer);
begin
   if not Assigned(self.fArrSpectr) then Exit;
   if not ((X >= fAreaAxX.Left) and (X <= fAreaAxX.Right))then Exit;
   //    
   if fRulerStop then Exit;
   // ------------------
   //  
   BmpShowSig();
   //    
   fMouseX := X;
   //  
   BmpShowRuler(Shift, fMouseX, Y);
   // ------------------
   //  X - mouse    
   MouseXToArrIndx(fMouseX);
   //       
   BmpSPointInfo(fArrIndx);
   // ----------------
   //  fBMP  fImg
   BmpToImg();
end;
// -----------------------------------------------------------------
//   
function TSignalScope.DialogColor(RqDefColor : TColor) : TColor;
var  wDialog : TColorDialog;
begin
  Result  := RqDefColor;
  wDialog := TColorDialog.Create(nil);
  //   
  if wDialog.Execute
  then begin
      Result := wDialog.Color;
  end;
  wDialog.Free;
end;
// -----------------------------------------------------------------
//  /   PopUpMemu   DialogLoadFromFile()
procedure TSignalScope.DialogLoadSpectrOnOff(RqOn : boolean);
var MenuItem : TMenuItem;
begin
   //    MenuItem
   MenuItem := FindMenuItem(fPUMenu,'mLoadSpectrFromFile');
   if MenuItem <> nil then MenuItem.Enabled := RqOn;
end;
// ------------------------------------------------------------------
//    PopupMenu
procedure  TSignalScope.GreateAndConnecPopUpMenu();
var MainItems : array of TMenuItem;
    SubItems0 : array of TMenuItem;   // 
    SubItems1 : array of TMenuItem;   // 
    SubItems2 : array of TMenuItem;   // 
    SubItems3 : array of TMenuItem;   // 
begin
   // ----------------------
   //   
   // ----------------------
   //  SubMenu0 Items
   SetLength(SubItems0,1);
   // -------
   SubItems0[0]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mRulerStop');
   SubItems0[0].Tag := 100;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu1 Items
   SetLength(SubItems1,1);
   // -------
   SubItems1[0]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mLoadSpectrFromFile');
   SubItems1[0].Tag := 200;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu2 Items
   SetLength(SubItems2,2);
   // -------
   SubItems2[0]:= NewItem('   ...', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mSaveToFileAS');
   SubItems2[0].Tag := 300;
   // -------
   SubItems2[1]:= NewItem('   Excel', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mExcel');
   SubItems2[1].Tag := 301;
   // ----------------------
   //   
   // ----------------------
   //  SubMenu3 Items
   SetLength(SubItems3,5);
   // -------
   SubItems3[0]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mBgColor');
   SubItems3[0].Tag := 400;
   // -------
   SubItems3[1]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mSignalColor');
   SubItems3[1].Tag := 401;
   // -------
   SubItems3[2]:= NewItem('-  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'mBW_Theme');
   SubItems3[2].Tag := 402;
   // -------
   // 
   SubItems3[3]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'mSeparator4');
   SubItems3[3].Tag := 0;
   // ---------
   SubItems3[4]:= NewItem('     ...',
                           TextToShortCut(''),
                           False, True, MenuClick, 0, 'mSaveImgToFile');
   SubItems3[4].Tag := 403;
   // ----------------------
   //  MainMenu Items
   // ----------------------
   SetLength(MainItems,7);
   // -------    0
   MainItems[0]:= NewSubMenu('  ',
                              0, 'mCTRL', SubItems0, True);
   // --------  
   MainItems[1]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    1
   MainItems[2]:= NewSubMenu(' ...',
                              0, 'mLoad', SubItems1, True);
   // --------  
   MainItems[3]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    2
   MainItems[4]:= NewSubMenu(' ...',
                              0, 'mSave', SubItems2, True);
   // --------  
   MainItems[5]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, 'SEP');
   // -------    3
   MainItems[6]:= NewSubMenu('',
                              0, 'mView', SubItems3, True);
   // ----------------------------
   //  PopupMenu
   fPUMenu := NewPopupMenu(fImg, 'Menu', paLeft, True, MainItems);
   //  PopupMenu
   fImg.PopupMenu := fPUMenu;

   // ----------------------------
   SetLength(SubItems0,0);
   SetLength(SubItems1,0);
   SetLength(SubItems2,0);
   SetLength(SubItems3,0);
   // ----------------------------
   SetLength(MainItems,0);
   // ----------------------------
   //  1:     ,   
   //  ShortCut     Click
   //  2:  fdImgList    
   //    RadioItem   
end;
// --------------------------------------------------------------------
//    
procedure TSignalScope.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item  :=  TMenuItem(Sender);
   case Item.Tag of
   //-----------
   // 
   //-----------
   100 : begin //   
          if not Assigned(fArrSpectr) then Exit;
          if Item.Checked
          then fRulerStop  := False
          else fRulerStop  := True;
          Item.Checked := fRulerStop;
          ReShow();
         end;
   //-----------
   // 
   //-----------
   200 : begin  //    
          DialogLoadFromSpecrtFile();
         end;
   //-----------
   // 
   //-----------
   300 : begin  //    
          if not Assigned(fArrSpectr) then Exit;
          DialogSaveToFile();
       end;
   301 : begin  //    Excel
          if not Assigned(fArrSpectr) then Exit;
          ExportToExcel();
       end;
   //-----------
   // 
   //-----------
   400 : begin  //   
          fBgColor := DialogColor(fBgColor);
          ReShow();
         end;
   401 : begin  //    
          fSignalColor := DialogColor(fSignalColor);
          ReShow();
         end;
   402 : begin // -  
          if Item.Checked
          then fBWMode  := False
          else fBWMode  := True;
          Item.Checked := fBWMode;
          ReShow();
         end;
   403 : begin  //    
          DialogSavePicture (fImg);
         end;
   end;
end;









end.
